/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.Activator;
import org.simantics.interop.update.editor.UpdateEditorInput;
import org.simantics.interop.update.model.ModelUpdate;
import org.simantics.interop.update.model.PropertyChange;
import org.simantics.interop.update.model.UpdateList;
import org.simantics.interop.update.model.UpdateNode;
import org.simantics.interop.update.model.UpdateOp;
import org.simantics.interop.update.model.UpdateStatus;
import org.simantics.interop.update.model.UpdateTree;
import org.simantics.interop.utils.TableUtils;
import org.simantics.utils.ui.ExceptionUtils;

public abstract class ModelUpdateEditor
extends Composite
implements ModelUpdate.WarningListener {
    private Composite errorComposite;
    private CheckboxTreeViewer changeBrowser;
    private TableViewer changeViewer;
    private Button updateAllButton;
    private Button updateSelectedButton;
    private LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources());
    private Image checked;
    private Image unchecked;
    private Image warning;
    private Color containsColor;
    private Color deletedColor;
    private Color addedColor;
    private ModelUpdate update;
    private HashSet<UpdateNode> selectedStructure = new HashSet();
    private List<ICheckStateListener> checkStateListeners = new ArrayList<ICheckStateListener>();

    public ModelUpdateEditor(Composite parent) {
        super(parent, 0);
        this.checked = this.manager.createImage(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/tick.png"));
        this.unchecked = this.manager.createImage(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/cross.png"));
        this.warning = this.manager.createImage(Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/error.png"));
        this.containsColor = new Color((Device)parent.getDisplay(), new RGB(255, 255, 220));
        this.deletedColor = new Color((Device)parent.getDisplay(), new RGB(255, 220, 220));
        this.addedColor = new Color((Device)parent.getDisplay(), new RGB(220, 255, 220));
        this.setLayout((Layout)new GridLayout(1, false));
        this.errorComposite = new Composite((Composite)this, 2048);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        this.errorComposite.setLayoutData((Object)data);
        this.errorComposite.setLayout((Layout)new GridLayout(2, false));
        this.errorComposite.setVisible(false);
        Composite fillComposite = new Composite((Composite)this, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        fillComposite.setLayoutData((Object)data);
        fillComposite.setLayout((Layout)new FillLayout(512));
        this.changeBrowser = new CheckboxTreeViewer(fillComposite, 68098);
        this.changeBrowser.setContentProvider((IContentProvider)new UpdateTreeContentProvider());
        this.changeBrowser.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.changeBrowser);
        TreeViewerColumn dataColumn = TableUtils.addColumn((TreeViewer)this.changeBrowser, (String)"Data", (boolean)true, (int)600);
        dataColumn.setLabelProvider((CellLabelProvider)new UpdateNodeLabelProvider());
        this.changeBrowser.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                UpdateNode node = (UpdateNode)event.getElement();
                if (node.getOp() != null) {
                    node.getOp().select(Boolean.TRUE.equals(event.getChecked()));
                }
                ModelUpdateEditor.this.refreshChecked();
            }
        });
        this.changeBrowser.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                event.getTreeViewer().getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelUpdateEditor.this.refreshChecked();
                    }
                });
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.changeBrowser.setUseHashlookup(true);
        this.changeViewer = new TableViewer(fillComposite, 68098);
        this.changeViewer.getTable().setHeaderVisible(true);
        this.changeViewer.getTable().setLinesVisible(true);
        this.changeViewer.setContentProvider((IContentProvider)new ModificationListContentProvider());
        this.changeViewer.setUseHashlookup(true);
        TableViewerColumn selection = TableUtils.addColumn((TableViewer)this.changeViewer, (String)this.getColumntTitle(0), (boolean)false, (boolean)false, (int)20);
        TableViewerColumn diagram = TableUtils.addColumn((TableViewer)this.changeViewer, (String)this.getColumntTitle(1), (boolean)true, (boolean)true, (int)100);
        TableViewerColumn symbol = TableUtils.addColumn((TableViewer)this.changeViewer, (String)this.getColumntTitle(2), (boolean)true, (boolean)true, (int)100);
        TableViewerColumn property = TableUtils.addColumn((TableViewer)this.changeViewer, (String)this.getColumntTitle(3), (boolean)true, (boolean)true, (int)100);
        TableViewerColumn oldValue = TableUtils.addColumn((TableViewer)this.changeViewer, (String)this.getColumntTitle(4), (boolean)true, (boolean)true, (int)100);
        TableViewerColumn newValue = TableUtils.addColumn((TableViewer)this.changeViewer, (String)this.getColumntTitle(5), (boolean)true, (boolean)true, (int)100);
        diagram.setLabelProvider((CellLabelProvider)this.getLabelProvider(1));
        symbol.setLabelProvider((CellLabelProvider)this.getLabelProvider(2));
        property.setLabelProvider((CellLabelProvider)this.getLabelProvider(3));
        oldValue.setLabelProvider((CellLabelProvider)this.getLabelProvider(4));
        newValue.setLabelProvider((CellLabelProvider)this.getLabelProvider(5));
        selection.setLabelProvider((CellLabelProvider)new SelectionLabelProvider());
        selection.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelUpdateEditor.this.update.getUpdateList().getChanges().size() > 0) {
                    if (ModelUpdateEditor.this.update.getUpdateList().getSelected().size() > 0) {
                        ModelUpdateEditor.this.update.getUpdateList().clearSelected();
                    } else {
                        for (PropertyChange nr : ModelUpdateEditor.this.update.getUpdateList().getChanges()) {
                            nr.select(true);
                        }
                    }
                    ModelUpdateEditor.this.changeViewer.refresh();
                }
            }
        });
        selection.setEditingSupport((EditingSupport)new SelectionEditingSupport((ColumnViewer)this.changeViewer));
        Composite buttonComposite = new Composite((Composite)this, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1024;
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(buttonComposite, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)data);
        this.updateAllButton = new Button(buttonComposite, 8);
        this.updateAllButton.setText("Update All");
        this.updateAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelUpdateEditor.this.applyAll();
            }
        });
        this.updateSelectedButton = new Button(buttonComposite, 8);
        this.updateSelectedButton.setText("Update Selected");
        this.updateSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelUpdateEditor.this.applySelected();
            }
        });
    }

    protected Session getSession() {
        return Simantics.getSession();
    }

    protected String getColumntTitle(int i) {
        switch (i) {
            case 0: {
                return "!";
            }
            case 1: {
                return "Diagram";
            }
            case 2: {
                return "Symbol";
            }
            case 3: {
                return "Property";
            }
            case 4: {
                return "Old Value";
            }
            case 5: {
                return "New Value";
            }
        }
        throw new RuntimeException("Unknown column index" + i);
    }

    protected abstract ColumnLabelProvider getLabelProvider(int var1);

    public GraphChanges getChanges() {
        return this.update.getChanges();
    }

    public UpdateTree getUpdateTree() {
        return this.update.getUpdateTree();
    }

    public UpdateList getUpdateList() {
        return this.update.getUpdateList();
    }

    public CheckboxTreeViewer getChangeBrowser() {
        return this.changeBrowser;
    }

    public TableViewer getChangeViewer() {
        return this.changeViewer;
    }

    @Override
    public void showWarning(ModelUpdate update, String text) {
        this.errorComposite.setVisible(true);
        Label label = new Label(this.errorComposite, 0);
        label.setImage(this.warning);
        label = new Label(this.errorComposite, 0);
        label.setText(text);
        this.layout(true);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add(listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove(listener);
    }

    public void refreshChecked() {
        Stack<UpdateNode> nodeStack = new Stack<UpdateNode>();
        nodeStack.push(this.update.getUpdateTree().getRootNode());
        while (!nodeStack.isEmpty()) {
            UpdateNode n = (UpdateNode)nodeStack.pop();
            if (n.getOp() != null) {
                UpdateOp op = n.getOp();
                if (!op.isChange()) {
                    this.changeBrowser.setGrayed((Object)n, true);
                    this.changeBrowser.setChecked((Object)n, true);
                } else {
                    boolean applied = op.applied();
                    if (applied) {
                        this.changeBrowser.setChecked((Object)n, true);
                        this.changeBrowser.setGrayed((Object)n, true);
                        this.selectedStructure.remove(n);
                    } else {
                        boolean sel = op.selected();
                        if (sel) {
                            this.selectedStructure.add(n);
                        } else {
                            this.selectedStructure.remove(n);
                        }
                        this.changeBrowser.setChecked((Object)n, sel);
                        this.changeBrowser.setGrayed((Object)n, false);
                    }
                }
            } else {
                this.changeBrowser.setGrayed((Object)n, true);
                this.changeBrowser.setChecked((Object)n, true);
            }
            for (UpdateNode c : n.getChildren()) {
                nodeStack.add(c);
            }
        }
        this.changeBrowser.refresh();
        for (ICheckStateListener l : this.checkStateListeners) {
            l.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.changeBrowser, null, false));
        }
        this.changeViewer.refresh();
    }

    protected abstract ModelUpdate createUpdate();

    public void load(UpdateEditorInput uei) {
        Resource oldModel = uei.getR1();
        Resource newModel = uei.getR2();
        Resource originalModel = uei.getR3();
        boolean newDistinct = uei.isNewDistinct();
        try {
            if (this.update != null) {
                this.update.removeListener(this);
            }
            this.update = this.createUpdate();
            this.update.addListener(this);
            this.update.setInput(oldModel, newModel, originalModel, newDistinct);
        }
        catch (DatabaseException e) {
            Text text = new Text((Composite)this, 2);
            text.setText(e.getMessage());
            e.printStackTrace();
            return;
        }
        this.setInputs();
        this.refreshChecked();
    }

    protected void setInputs() {
        this.changeViewer.setInput(this.update.getUpdateList().getChanges());
        this.changeBrowser.setInput((Object)this.update.getUpdateTree());
    }

    private void applyAll() {
        this.updateAllButton.setEnabled(false);
        this.updateSelectedButton.setEnabled(false);
        this.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                ModelUpdateEditor.this.update.applyAll(graph);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelUpdateEditor.this.updateAllButton.setEnabled(true);
                        ModelUpdateEditor.this.updateSelectedButton.setEnabled(true);
                        ModelUpdateEditor.this.refreshChecked();
                        ModelUpdateEditor.this.changeViewer.refresh();
                    }
                });
            }
        }, e -> {
            if (e != null) {
                ExceptionUtils.logAndShowError((String)"Cannot update model", (Throwable)e);
            }
        });
    }

    private void applySelected() {
        this.updateAllButton.setEnabled(false);
        this.updateSelectedButton.setEnabled(false);
        this.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                ModelUpdateEditor.this.update.applySelected(graph);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelUpdateEditor.this.changeViewer.refresh();
                        ModelUpdateEditor.this.updateAllButton.setEnabled(true);
                        ModelUpdateEditor.this.updateSelectedButton.setEnabled(true);
                        ModelUpdateEditor.this.refreshChecked();
                    }
                });
            }
        });
    }

    private class ModificationListContentProvider
    implements IStructuredContentProvider {
        private ModificationListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return null;
            }
            Collection coll = (Collection)inputElement;
            return coll.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class SelectionEditingSupport
    extends EditingSupport {
        public SelectionEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor(null, 32);
        }

        protected Object getValue(Object element) {
            if (ModelUpdateEditor.this.update == null || !ModelUpdateEditor.this.update.isInit()) {
                return false;
            }
            PropertyChange pc = (PropertyChange)element;
            return pc.selected();
        }

        protected void setValue(Object element, Object value) {
            if (ModelUpdateEditor.this.update == null || !ModelUpdateEditor.this.update.isInit()) {
                return;
            }
            PropertyChange pc = (PropertyChange)element;
            if (Boolean.TRUE.equals(value)) {
                pc.select(true);
            } else {
                pc.select(false);
            }
            this.getViewer().refresh(element);
        }
    }

    private class SelectionLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            return "";
        }

        public Image getImage(Object element) {
            if (ModelUpdateEditor.this.update == null || !ModelUpdateEditor.this.update.isInit()) {
                return null;
            }
            PropertyChange pc = (PropertyChange)element;
            if (pc.selected()) {
                return ModelUpdateEditor.this.checked;
            }
            return ModelUpdateEditor.this.unchecked;
        }
    }

    private class UpdateNodeLabelProvider
    extends ColumnLabelProvider {
        private UpdateNodeLabelProvider() {
        }

        public String getText(Object element) {
            UpdateNode node = (UpdateNode)element;
            return node.getLabel();
        }

        public Image getImage(Object element) {
            final UpdateNode node = (UpdateNode)element;
            try {
                ImageDescriptor id = (ImageDescriptor)ModelUpdateEditor.this.getSession().syncRequest((Read)new Read<ImageDescriptor>(){

                    public ImageDescriptor perform(ReadGraph graph) throws DatabaseException {
                        return node.getImage(graph);
                    }
                });
                return ModelUpdateEditor.this.manager.createImage(id);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getToolTipText(Object element) {
            UpdateNode node = (UpdateNode)element;
            if (node.getOp() != null) {
                return node.getOp().toString();
            }
            return null;
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 1000;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 10000;
        }

        public Color getBackground(Object element) {
            UpdateNode node = (UpdateNode)element;
            UpdateStatus status = node.getStatus();
            if (status == UpdateStatus.CONTAINS) {
                return ModelUpdateEditor.this.containsColor;
            }
            if (status == UpdateStatus.DELETED) {
                return ModelUpdateEditor.this.deletedColor;
            }
            if (status == UpdateStatus.NEW) {
                return ModelUpdateEditor.this.addedColor;
            }
            return null;
        }
    }

    private class UpdateTreeContentProvider
    implements ITreeContentProvider {
        private UpdateTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof UpdateTree) {
                return new Object[]{((UpdateTree)inputElement).getRootNode()};
            }
            if (inputElement instanceof UpdateNode) {
                UpdateNode node = (UpdateNode)inputElement;
                return node.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            UpdateNode node = (UpdateNode)parentElement;
            return node.getChildren().toArray();
        }

        public boolean hasChildren(Object element) {
            UpdateNode node = (UpdateNode)element;
            return node.getChildren().size() > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

