/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel.poi.parser.streaming;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.simantics.excel.poi.parser.streaming.RowImpl;
import org.simantics.excel.poi.parser.streaming.SheetImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSSheetHandler
extends DefaultHandler {
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    int rowIndex = 0;
    List<String> row = new ArrayList<String>();
    List<String> rowTypes = new ArrayList<String>();
    String cellType;
    String cellId;
    SheetImpl sheet;

    public XSSSheetHandler(SharedStringsTable sst) {
        this.sst = sst;
    }

    public void setSheet(SheetImpl sheet) {
        this.sheet = sheet;
    }

    public void writeRow(Row row) {
        System.out.println(row);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("c")) {
            this.cellType = attributes.getValue("t");
            this.cellId = attributes.getValue("r");
            if (this.cellType != null) {
                this.nextIsString = this.cellType.equals("s");
            } else {
                this.nextIsString = false;
                this.cellType = "v";
            }
        }
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString) {
            int idx = Integer.parseInt(this.lastContents);
            this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            this.nextIsString = false;
        }
        if (name.equals("c")) {
            int colIndex = this.getColIndex(this.cellId);
            int i = this.row.size();
            while (i < colIndex) {
                this.row.add(null);
                this.rowTypes.add("s");
                ++i;
            }
            this.row.add(this.lastContents);
            this.rowTypes.add(this.cellType);
            this.lastContents = "";
        } else if (name.equals("row")) {
            this.writeRow(new RowImpl(this.sheet, this.row, this.rowTypes, this.rowIndex));
            ++this.rowIndex;
            this.row.clear();
            this.rowTypes.clear();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = String.valueOf(this.lastContents) + new String(ch, start, length);
    }

    private int getColIndex(String id) {
        int len = 0;
        int range = 26;
        int i = 0;
        while (i < id.length()) {
            char c = id.charAt(i);
            if ('A' > c || c > 'Z') break;
            len = i + 1;
            ++i;
        }
        int index = 0;
        int i2 = 0;
        while (i2 < len) {
            char c = id.charAt(len - i2 - 1);
            index += c - 65 + i2 * range;
            ++i2;
        }
        return index;
    }
}

