/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel.poi.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ColumnResolver {
    private Map<String, int[]> values = new HashMap<String, int[]>();
    private Map<String, Type> types = new HashMap<String, Type>();
    private Set<String> optional = new HashSet<String>();
    private Set<String> resolved = new HashSet<String>();

    public void addSingleColumn(String id) {
        this.addSingleColumn(id, true);
    }

    public void addSingleColumn(String id, boolean required) {
        this.types.put(id, Type.SINGLE);
        if (!required) {
            this.optional.add(id);
        }
    }

    public void addMultiColumn(String id) {
        this.addMultiColumn(id, true);
    }

    public void addMultiColumn(String id, boolean required) {
        this.types.put(id, Type.MULTI);
        if (!required) {
            this.optional.add(id);
        }
    }

    public int getSingleColumn(String id) {
        int[] val = this.values.get(id);
        if (val == null) {
            return -1;
        }
        if (val.length == 0) {
            return -1;
        }
        return val[0];
    }

    public int[] getMultiColumn(String id) {
        return this.values.get(id);
    }

    public boolean resolve(Row row) {
        return this.resolve(row, true);
    }

    public boolean resolve(Row row, boolean ignoreCase) {
        this.values.clear();
        this.resolved.clear();
        if (row == null) {
            return false;
        }
        int i = 0;
        while (i <= row.getLastCellNum()) {
            Cell cell = row.getCell(i);
            if (cell != null) {
                int colIndex = cell.getColumnIndex();
                String value = cell.getStringCellValue();
                for (Map.Entry<String, Type> col : this.types.entrySet()) {
                    String id = col.getKey();
                    if (!id.equals(value) && (!ignoreCase || !id.equalsIgnoreCase(value))) continue;
                    if (col.getValue() == Type.SINGLE) {
                        this.values.put(id, new int[]{colIndex});
                    } else {
                        int[] curr = this.values.get(id);
                        if (curr == null) {
                            this.values.put(id, new int[]{colIndex});
                        } else {
                            int[] n = new int[curr.length + 1];
                            System.arraycopy(curr, 0, n, 0, curr.length);
                            n[curr.length] = colIndex;
                            this.values.put(id, n);
                        }
                    }
                    this.resolved.add(id);
                    break;
                }
            }
            ++i;
        }
        for (Map.Entry<String, Type> col : this.types.entrySet()) {
            if (this.optional.contains(col.getKey()) || this.resolved.contains(col.getKey())) continue;
            return false;
        }
        return true;
    }

    private static enum Type {
        SINGLE,
        MULTI;

    }
}

