/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import vtk.vtkRenderWindow;
import vtk.vtkSettings;
import vtk.vtkTesting;

public class vtkTesting2 {
    public static final int FAILED = 0;
    public static final int PASSED = 1;
    public static final int NOT_RUN = 2;
    public static final int DO_INTERACTOR = 3;
    private static vtkTesting Tester = null;

    private static int LoadLib(String lib, boolean verbose) {
        try {
            if (verbose) {
                System.out.println("Try to load: " + lib);
            }
            Runtime.getRuntime().load(lib);
        }
        catch (UnsatisfiedLinkError e) {
            if (verbose) {
                System.out.println("Failed to load: " + lib);
            }
            return 0;
        }
        if (verbose) {
            System.out.println("Successfully loaded: " + lib);
        }
        return 1;
    }

    private static void LoadLibrary(String path, String library, boolean verbose) {
        String lname = System.mapLibraryName(library);
        String sep = System.getProperty("file.separator");
        String libname = String.valueOf(path) + sep + lname;
        String releaselibname = String.valueOf(path) + sep + "Release" + sep + lname;
        String debuglibname = String.valueOf(path) + sep + "Debug" + sep + lname;
        if (vtkTesting2.LoadLib(library, verbose) != 1 && vtkTesting2.LoadLib(libname, verbose) != 1 && vtkTesting2.LoadLib(releaselibname, verbose) != 1 && vtkTesting2.LoadLib(debuglibname, verbose) != 1) {
            System.out.println("Problem loading apropriate library");
        }
    }

    public static void Initialize(String[] args) {
        vtkTesting2.Initialize(args, false);
    }

    public static void Initialize(String[] args, boolean verbose) {
        String lpath = vtkSettings.GetVTKLibraryDir();
        if (lpath != null) {
            String path_separator = System.getProperty("path.separator");
            String s = System.getProperty("java.library.path");
            s = String.valueOf(s) + path_separator + lpath;
            System.setProperty("java.library.path", s);
        }
        String lname = System.mapLibraryName("vtkCommonJava");
        String[] kits = vtkSettings.GetKits();
        int cc = 0;
        while (cc < kits.length) {
            vtkTesting2.LoadLibrary(lpath, "vtk" + kits[cc] + "Java", verbose);
            ++cc;
        }
        Tester = new vtkTesting();
        cc = 0;
        while (cc < args.length) {
            Tester.AddArgument(args[cc]);
            ++cc;
        }
    }

    public static boolean IsInteractive() {
        return Tester.IsInteractiveModeSpecified() != 0;
    }

    public static void Exit(int retVal) {
        if (retVal == 0 || retVal == 2) {
            System.out.println("Test failed or was not run");
            System.exit(1);
        }
        System.out.println("Test passed");
        System.exit(0);
    }

    public static int RegressionTest(vtkRenderWindow renWin, int threshold) {
        Tester.SetRenderWindow(renWin);
        if (Tester.RegressionTest(threshold) == 1) {
            return 1;
        }
        System.out.println("Image difference: " + Tester.GetImageDifference());
        return 0;
    }
}

