/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    COMMON("vtkCommonJava"),
    FILTERING("vtkFilteringJava"),
    GEOVIS("vtkGeovisJava"),
    GRAPHICS("vtkGraphicsJava"),
    HYBRID("vtkHybridJava"),
    IMAGING("vtkImagingJava"),
    INFOVIS("vtkInfovisJava"),
    IO("vtkIOJava"),
    RENDERING("vtkRenderingJava"),
    VIEWS("vtkViewsJava"),
    VOLUME_RENDERING("vtkVolumeRenderingJava"),
    WIDGETS("vtkWidgetsJava"),
    CHARTS("vtkChartsJava");

    private String nativeLibraryName;
    private boolean loaded;

    public static boolean LoadAllNativeLibraries() {
        boolean isEveryThingLoaded = true;
        vtkNativeLibrary[] vtkNativeLibraryArray = vtkNativeLibrary.values();
        int n = vtkNativeLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            vtkNativeLibrary lib = vtkNativeLibraryArray[n2];
            try {
                lib.LoadLibrary();
            }
            catch (UnsatisfiedLinkError e) {
                isEveryThingLoaded = false;
            }
            ++n2;
        }
        return isEveryThingLoaded;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... nativeLibraries) {
        vtkNativeLibrary[] vtkNativeLibraryArray = nativeLibraries;
        int n = nativeLibraries.length;
        int n2 = 0;
        while (n2 < n) {
            vtkNativeLibrary lib = vtkNativeLibraryArray[n2];
            lib.LoadLibrary();
            ++n2;
        }
    }

    public static void DisableOutputWindow(File logFile) {
        if (logFile == null) {
            logFile = new File("vtkError.txt");
        }
        vtkFileOutputWindow outputError = new vtkFileOutputWindow();
        outputError.SetFileName(logFile.getAbsolutePath());
        outputError.SetInstance(outputError);
    }

    private vtkNativeLibrary(String nativeLibraryName) {
        this.nativeLibraryName = nativeLibraryName;
        this.loaded = false;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File dir = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(dir.getAbsolutePath());
                File libPath = new File(dir, System.mapLibraryName(this.nativeLibraryName));
                if (libPath.exists()) {
                    try {
                        Runtime.getRuntime().load(libPath.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String vtkLibDir) {
        if (vtkLibDir != null) {
            String path_separator = System.getProperty("path.separator");
            String s = System.getProperty("java.library.path");
            if (!s.contains(vtkLibDir)) {
                s = String.valueOf(s) + path_separator + vtkLibDir;
                System.setProperty("java.library.path", s);
            }
        }
    }
}

