/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import vtk.vtkObject;
import vtk.vtkReferenceInformation;

public class vtkJavaGarbageCollector {
    private ScheduledExecutorService executor;
    private Runnable deleteRunnable;
    private Runnable deferredEdtRunnable;
    private long periodTime = 1L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean autoCollectionRunning = false;
    private boolean debug = false;

    public vtkJavaGarbageCollector() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.deleteRunnable = new Runnable(){

            @Override
            public void run() {
                vtkReferenceInformation info = vtkObject.JAVA_OBJECT_MANAGER.gc(vtkJavaGarbageCollector.this.debug);
                if (vtkJavaGarbageCollector.this.debug) {
                    System.out.println(info);
                    System.out.println(info.listKeptReferenceToString());
                    System.out.println(info.listRemovedReferenceToString());
                }
            }
        };
        this.deferredEdtRunnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(vtkJavaGarbageCollector.this.deleteRunnable);
            }
        };
    }

    public void SetScheduleTime(long period, TimeUnit timeUnit) {
        this.periodTime = period;
        this.timeUnit = timeUnit;
        this.SetAutoGarbageCollection(this.autoCollectionRunning);
    }

    public void SetDebug(boolean debug) {
        this.debug = debug;
    }

    public void SetAutoGarbageCollection(boolean doGarbageCollectionInEDT) {
        this.autoCollectionRunning = doGarbageCollectionInEDT;
        this.executor.shutdown();
        if (doGarbageCollectionInEDT) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.scheduleAtFixedRate(this.deferredEdtRunnable, this.periodTime, this.periodTime, this.timeUnit);
        }
    }

    public void Start() {
        this.SetAutoGarbageCollection(true);
    }

    public void Stop() {
        this.SetAutoGarbageCollection(false);
    }

    public Runnable GetDeleteRunnable() {
        return this.deleteRunnable;
    }
}

