/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.opencascade.vtk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jcae.opencascade.jni.BRepMesh_IncrementalMesh;
import org.jcae.opencascade.jni.TopAbs_ShapeEnum;
import org.jcae.opencascade.jni.TopExp_Explorer;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.opencascade.OCCTTool;
import org.simantics.opencascade.vtk.EdgePointsFilter;
import org.simantics.opencascade.vtk.VTKOCCTool;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkActor;
import vtk.vtkAlgorithmOutput;
import vtk.vtkCleanPolyData;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkFeatureEdges;
import vtk.vtkGlyph3D;
import vtk.vtkMapper;
import vtk.vtkPanel;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;
import vtk.vtkPolyDataSilhouette;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkProperty;
import vtk.vtkRenderer;
import vtk.vtkSphereSource;

public class vtkSolidObject {
    public static double deflection = 0.001;
    public static double featureAngle = 30.0;
    public static boolean computeNormals = true;
    public static boolean cleanPart = false;
    public static boolean mergePoints = false;
    private vtkPanel panel;
    private TopoDS_Shape shape;
    private List<vtkProp3D> actors = new ArrayList<vtkProp3D>(2);
    private List<vtkProp3D> solid = new ArrayList<vtkProp3D>(1);
    private List<vtkProp3D> edges = new ArrayList<vtkProp3D>(1);
    private vtkActor silhouette = null;
    private boolean errors = false;
    private static double TOLERANCE = 0.01;

    public vtkSolidObject(vtkPanel panel, TopoDS_Shape shape) {
        this.shape = shape;
        this.panel = panel;
    }

    public void visualizeSolid(boolean showEdges, boolean showVertices) {
        this.visualizeSolid(true, showEdges, showVertices);
    }

    public void visualizeSolid(boolean showFaces, boolean showEdges, boolean showVertices) {
        this.visualizeSolid(showFaces, showEdges, showVertices, false);
    }

    public void visualizeSolid(boolean showFaces, boolean showEdges, boolean showVertices, boolean showSilhouette) {
        this.clearActorsAWT();
        this.errors = false;
        Pair<vtkPolyData, Boolean> res = vtkSolidObject.createSolidMesh(this.shape);
        if (res == null) {
            this.errors = true;
            return;
        }
        vtkPolyData data = (vtkPolyData)res.first;
        if (!((Boolean)res.second).booleanValue()) {
            this.errors = true;
        }
        if (showFaces) {
            this.solid.add((vtkProp3D)vtkSolidObject.createActor(data));
        }
        if (showEdges) {
            vtkActor edge = vtkSolidObject.createEdgesActor(data);
            this.edges.add((vtkProp3D)edge);
            if (showVertices) {
                this.actors.add((vtkProp3D)vtkSolidObject.createVerticesActor(edge));
            }
        }
        if (showSilhouette) {
            this.silhouette = vtkSolidObject.createSilhouette(this.panel.GetRenderer(), data);
        }
        this.actors.addAll(this.solid);
        this.actors.addAll(this.edges);
        if (this.silhouette != null) {
            this.actors.add((vtkProp3D)this.silhouette);
        }
        data.Delete();
        this.showActorsAWT();
    }

    public void visualizeFaces(boolean showEdges, boolean showVertices) {
        this.errors = false;
        this.clearActorsAWT();
        Collection<vtkPolyData> datas = vtkSolidObject.createFaceMeshes(this.shape);
        for (vtkPolyData data : datas) {
            if (data == null) {
                this.errors = true;
                continue;
            }
            this.solid.add((vtkProp3D)vtkSolidObject.createActor(data));
            if (showEdges) {
                vtkActor edgesActor = vtkSolidObject.createEdgesActor(data);
                this.edges.add((vtkProp3D)edgesActor);
                if (showVertices) {
                    this.actors.add((vtkProp3D)vtkSolidObject.createVerticesActor(edgesActor));
                }
            }
            data.Delete();
        }
        this.actors.addAll(this.solid);
        this.actors.addAll(this.edges);
        this.showActorsAWT();
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public List<vtkProp3D> getActors() {
        assert (Thread.currentThread() == AWTThread.getThreadAccess().getThread());
        return this.actors;
    }

    public List<vtkProp3D> getSolid() {
        assert (Thread.currentThread() == AWTThread.getThreadAccess().getThread());
        return this.solid;
    }

    public List<vtkProp3D> getEdges() {
        assert (Thread.currentThread() == AWTThread.getThreadAccess().getThread());
        return this.edges;
    }

    public vtkActor getSilhouette() {
        assert (Thread.currentThread() == AWTThread.getThreadAccess().getThread());
        return this.silhouette;
    }

    public void showActorsAWT() {
        assert (Thread.currentThread() == AWTThread.getThreadAccess().getThread());
        vtkRenderer ren = this.panel.GetRenderer();
        for (vtkProp3D act : this.actors) {
            ren.AddActor((vtkProp)act);
        }
    }

    public void showActors() {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkSolidObject.this.showActorsAWT();
            }
        });
    }

    public void clearActorsAWT() {
        assert (Thread.currentThread() == AWTThread.getThreadAccess().getThread());
        if (this.actors.size() == 0) {
            return;
        }
        vtkRenderer ren = this.panel.GetRenderer();
        for (vtkProp3D act : this.actors) {
            if (act.GetVTKId() == 0L) continue;
            ren.RemoveActor((vtkProp)act);
            act.Delete();
        }
        this.actors.clear();
        this.solid.clear();
        this.edges.clear();
    }

    private void clearActorsAWT(List<vtkProp3D> actors) {
        assert (Thread.currentThread() == AWTThread.getThreadAccess().getThread());
        if (actors.size() == 0) {
            return;
        }
        vtkRenderer ren = this.panel.GetRenderer();
        this.panel.lock();
        for (vtkProp3D act : actors) {
            if (act.GetVTKId() == 0L) continue;
            ren.RemoveActor((vtkProp)act);
            act.Delete();
        }
        this.panel.unlock();
    }

    public void clearActors() {
        if (this.actors.size() == 0) {
            return;
        }
        final ArrayList<vtkProp3D> temp = new ArrayList<vtkProp3D>(this.actors.size());
        temp.addAll(this.actors);
        this.actors.clear();
        this.solid.clear();
        this.edges.clear();
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkSolidObject.this.clearActorsAWT(temp);
            }
        });
    }

    public void dispose() {
        if (this.shape != null) {
            this.shape.delete();
            this.shape = null;
        }
        this.clearActors();
    }

    public void delete() {
        if (this.shape != null) {
            this.shape.delete();
            this.shape = null;
        }
        this.clearActorsAWT();
    }

    public static Pair<vtkPolyData, Boolean> createSolidMesh(TopoDS_Shape shape) {
        boolean success = true;
        double volume = OCCTTool.getBoundingBoxDiagonal((TopoDS_Shape)shape);
        if (volume < TOLERANCE) {
            return null;
        }
        BRepMesh_IncrementalMesh mesh = new BRepMesh_IncrementalMesh(shape, deflection * volume);
        TopExp_Explorer expFace = new TopExp_Explorer();
        ArrayList<Double> meshPoints = new ArrayList<Double>();
        ArrayList<Integer> meshTriangles = new ArrayList<Integer>();
        expFace.init(shape, TopAbs_ShapeEnum.FACE);
        while (expFace.more()) {
            TopoDS_Face face = (TopoDS_Face)expFace.current();
            if (!OCCTTool.appendToMesh((TopoDS_Face)face, meshPoints, meshTriangles)) {
                success = false;
            }
            face.delete();
            expFace.next();
        }
        if (meshPoints.size() == 0 || meshTriangles.size() == 0) {
            return null;
        }
        vtkPolyData data = VTKOCCTool.createPartGrid(meshPoints, meshTriangles);
        expFace.delete();
        mesh.delete();
        return new Pair((Object)data, (Object)success);
    }

    public static Collection<vtkPolyData> createFaceMeshes(TopoDS_Shape shape) {
        double volume = OCCTTool.getBoundingBoxDiagonal((TopoDS_Shape)shape);
        ArrayList<vtkPolyData> faces = new ArrayList<vtkPolyData>();
        if (volume > TOLERANCE) {
            BRepMesh_IncrementalMesh mesh = new BRepMesh_IncrementalMesh(shape, deflection * volume);
            TopExp_Explorer expFace = new TopExp_Explorer();
            expFace.init(shape, TopAbs_ShapeEnum.FACE);
            while (expFace.more()) {
                TopoDS_Face face = (TopoDS_Face)expFace.current();
                vtkPolyData data = VTKOCCTool.createPartGrid(face);
                face.delete();
                faces.add(data);
                expFace.next();
            }
            expFace.delete();
            mesh.delete();
        }
        return faces;
    }

    public static vtkActor createActor(vtkPolyData partGrid) {
        vtkDataSetMapper partMapper = new vtkDataSetMapper();
        vtkCleanPolyData partCleaner = null;
        if (cleanPart) {
            partCleaner = new vtkCleanPolyData();
            partCleaner.SetInput((vtkDataObject)partGrid);
            if (mergePoints) {
                partCleaner.PointMergingOn();
            } else {
                partCleaner.PointMergingOff();
            }
        }
        if (computeNormals) {
            vtkAlgorithmOutput out;
            vtkPolyDataNormals partNormals = new vtkPolyDataNormals();
            if (cleanPart) {
                out = partCleaner.GetOutputPort();
                partNormals.SetInputConnection(out);
                out.Delete();
            } else {
                partNormals.SetInput((vtkDataObject)partGrid);
            }
            partNormals.SetFeatureAngle(featureAngle);
            out = partNormals.GetOutputPort();
            partMapper.SetInputConnection(out);
            out.Delete();
            partNormals.Delete();
        } else if (cleanPart) {
            vtkAlgorithmOutput out = partCleaner.GetOutputPort();
            partMapper.SetInputConnection(out);
            out.Delete();
        } else {
            partMapper.SetInput((vtkDataSet)partGrid);
        }
        partMapper.ScalarVisibilityOn();
        vtkActor partActor = new vtkActor();
        vtkProperty prop = partActor.GetProperty();
        prop.SetColor(1.0, 1.0, 0.0);
        prop.Delete();
        partActor.SetMapper((vtkMapper)partMapper);
        partMapper.Delete();
        if (cleanPart) {
            partCleaner.Delete();
        }
        return partActor;
    }

    public static vtkActor createEdgesActor(vtkPolyData partGrid) {
        vtkCleanPolyData partCleaner = null;
        if (cleanPart) {
            partCleaner = new vtkCleanPolyData();
            partCleaner.SetInput((vtkDataObject)partGrid);
            if (mergePoints) {
                partCleaner.PointMergingOn();
            } else {
                partCleaner.PointMergingOff();
            }
        }
        vtkFeatureEdges partEdges = new vtkFeatureEdges();
        if (cleanPart) {
            vtkAlgorithmOutput out = partCleaner.GetOutputPort();
            partEdges.SetInputConnection(out);
            out.Delete();
        } else {
            partEdges.SetInput((vtkDataObject)partGrid);
        }
        partEdges.FeatureEdgesOn();
        partEdges.BoundaryEdgesOn();
        partEdges.NonManifoldEdgesOn();
        partEdges.ManifoldEdgesOn();
        vtkDataSetMapper partEdgesMapper = new vtkDataSetMapper();
        vtkAlgorithmOutput out = partEdges.GetOutputPort();
        partEdgesMapper.SetInputConnection(out);
        out.Delete();
        partEdgesMapper.SetResolveCoincidentTopologyToPolygonOffset();
        partEdgesMapper.ScalarVisibilityOff();
        vtkActor partEdgesActor = new vtkActor();
        vtkProperty prop = partEdgesActor.GetProperty();
        prop.SetColor(0.0, 0.0, 0.0);
        prop.SetLineWidth(2.0);
        prop.Delete();
        partEdgesActor.SetMapper((vtkMapper)partEdgesMapper);
        partEdgesMapper.Delete();
        partEdges.Delete();
        if (cleanPart) {
            partCleaner.Delete();
        }
        return partEdgesActor;
    }

    public static vtkActor createVerticesActor(vtkActor partEdgesActor) {
        vtkDataSetMapper partEdgesMapper = (vtkDataSetMapper)partEdgesActor.GetMapper();
        vtkAlgorithmOutput out = partEdgesMapper.GetInputConnection(0, 0);
        vtkFeatureEdges partEdges = (vtkFeatureEdges)out.GetProducer();
        vtkActor edgePointsActor = vtkSolidObject.createVerticesActor(partEdges);
        partEdges.Delete();
        partEdgesMapper.Delete();
        return edgePointsActor;
    }

    public static vtkActor createVerticesActor(vtkFeatureEdges partEdges) {
        EdgePointsFilter edgePoints = new EdgePointsFilter();
        vtkAlgorithmOutput out = partEdges.GetOutputPort();
        edgePoints.SetInputConnection(out);
        out.Delete();
        vtkSphereSource sphereSource = new vtkSphereSource();
        vtkGlyph3D glyph3D = new vtkGlyph3D();
        out = sphereSource.GetOutputPort();
        glyph3D.SetSourceConnection(out);
        out.Delete();
        out = edgePoints.GetOutputPort();
        glyph3D.SetInputConnection(out);
        out.Delete();
        glyph3D.SetScaleFactor(0.03);
        glyph3D.Update();
        vtkPolyDataMapper partEdgePointsMapper = new vtkPolyDataMapper();
        out = glyph3D.GetOutputPort();
        partEdgePointsMapper.SetInputConnection(out);
        out.Delete();
        vtkActor edgePointsActor = new vtkActor();
        vtkProperty prop = edgePointsActor.GetProperty();
        prop.SetColor(0.0, 0.0, 1.0);
        prop.Delete();
        edgePointsActor.SetMapper((vtkMapper)partEdgePointsMapper);
        edgePointsActor.PickableOn();
        partEdgePointsMapper.Delete();
        edgePoints.Delete();
        sphereSource.Delete();
        return edgePointsActor;
    }

    public static vtkActor createSilhouette(vtkRenderer ren, vtkPolyData data) {
        vtkPolyDataSilhouette silhouette = new vtkPolyDataSilhouette();
        silhouette.SetInput((vtkDataObject)data);
        silhouette.SetCamera(ren.GetActiveCamera());
        silhouette.SetEnableFeatureAngle(0);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputConnection(silhouette.GetOutputPort());
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        actor.GetProperty().SetColor(0.0, 0.0, 1.0);
        actor.GetProperty().SetLineWidth(6.0);
        return actor;
    }
}

