/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.opencascade.vtk;

import java.util.HashSet;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.utils.datastructures.MapList;
import vtk.vtkCell;
import vtk.vtkIdList;
import vtk.vtkLine;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkProgrammableFilter;
import vtk.vtkVertex;

public class EdgePointsFilter
extends vtkProgrammableFilter {
    vtkPoints outputPoints;

    public EdgePointsFilter() {
        this.SetExecuteMethod((Object)this, "compute");
    }

    public void compute() {
        Object line;
        vtkPolyData polyDataInput = this.GetPolyDataInput();
        vtkPolyData polyDataOutput = this.GetPolyDataOutput();
        vtkPoints inputPoints = polyDataInput.GetPoints();
        this.outputPoints = new vtkPoints();
        MapList edgeIndices = new MapList();
        int i = 0;
        while (i < polyDataInput.GetNumberOfCells()) {
            vtkCell cell = polyDataInput.GetCell(i);
            if (cell.IsA("vtkLine") > 0) {
                line = (vtkLine)cell;
                int i1 = line.GetPointId(0);
                int i2 = line.GetPointId(1);
                if (!edgeIndices.contains((Object)i1, (Object)i2)) {
                    edgeIndices.add((Object)i1, (Object)i2);
                    edgeIndices.add((Object)i2, (Object)i1);
                }
                line.Delete();
            }
            ++i;
        }
        HashSet<Integer> vertices = new HashSet<Integer>();
        for (Integer i2 : edgeIndices.getKeys()) {
            List edges = edgeIndices.getValues((Object)i2);
            if (edges.size() != 2) {
                vertices.add(i2);
                continue;
            }
            double[] tp = inputPoints.GetPoint(i2.intValue());
            double[] ep1 = inputPoints.GetPoint(((Integer)edges.get(0)).intValue());
            double[] ep2 = inputPoints.GetPoint(((Integer)edges.get(1)).intValue());
            Point3d t = new Point3d(tp);
            Vector3d v1 = new Vector3d(ep1);
            Vector3d v2 = new Vector3d(ep2);
            v1.sub((Tuple3d)t);
            v2.sub((Tuple3d)t);
            double angle = Math.PI - v1.angle(v2);
            if (!(angle > 0.5235987755982988)) continue;
            vertices.add(i2);
        }
        line = vertices.iterator();
        while (line.hasNext()) {
            int i3 = (Integer)line.next();
            this.outputPoints.InsertNextPoint(inputPoints.GetPoint(i3));
        }
        polyDataOutput.Allocate(vertices.size(), vertices.size());
        vtkVertex vertex = new vtkVertex();
        vtkIdList list = vertex.GetPointIds();
        int i4 = 0;
        while (i4 < vertices.size()) {
            list.SetId(0, i4);
            polyDataOutput.InsertNextCell(vertex.GetCellType(), list);
            ++i4;
        }
        polyDataOutput.SetPoints(this.outputPoints);
        list.Delete();
        vertex.Delete();
        polyDataOutput.Delete();
        polyDataInput.Delete();
    }

    public void Delete() {
        this.outputPoints.Delete();
        super.Delete();
    }
}

