/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.rules.domain;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.structural.StructuralResource;

public class RelatedValueAccessor
implements IDomainAccessor<StructuralResource, Object> {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    Resource relation;
    Resource valueType;
    boolean useTypeResource;
    private boolean preventStructuralChanges = true;
    private boolean preventStructuralRootChanges = true;

    public RelatedValueAccessor(Resource relation, Resource valueType, boolean useTypeResource) {
        this.relation = relation;
        this.valueType = valueType;
        this.useTypeResource = useTypeResource;
    }

    public RelatedValueAccessor(Resource relation, Resource valueType, boolean useTypeResource, boolean preventStructuralChanges, boolean preventStructuralRootChanges) {
        this.relation = relation;
        this.valueType = valueType;
        this.useTypeResource = useTypeResource;
        this.preventStructuralChanges = preventStructuralChanges;
        this.preventStructuralRootChanges = preventStructuralRootChanges;
    }

    private boolean preventChange(StructuralResource element) {
        return this.preventStructuralChanges && element.isStructural() && (!element.isStructuralRoot() || this.preventStructuralRootChanges);
    }

    @Override
    public Object get(ReadGraph g, StructuralResource element) throws MappingException {
        Resource valueResource;
        block5: {
            Resource res;
            block4: {
                try {
                    LOGGER.info((Object)"        RelatedValueAccessor.get");
                    res = this.getServiceResource(g, element);
                    if (res != null) break block4;
                    return null;
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
            }
            valueResource = g.getPossibleObject(res, this.relation);
            if (valueResource != null) break block5;
            return null;
        }
        return g.getValue(valueResource);
    }

    @Override
    public boolean set(WriteGraph g, StructuralResource relement, Object value) throws MappingException {
        Statement valueStatement;
        Resource element;
        block20: {
            block19: {
                block17: {
                    block18: {
                        block14: {
                            block16: {
                                block15: {
                                    block13: {
                                        try {
                                            LOGGER.info((Object)"        RelatedValueAccessor.set");
                                            element = this.getServiceResource((ReadGraph)g, relement);
                                            if (element != null) break block13;
                                            return false;
                                        }
                                        catch (DatabaseException e) {
                                            throw new MappingException(e);
                                        }
                                    }
                                    valueStatement = g.getPossibleStatement(element, this.relation);
                                    if (valueStatement != null) break block14;
                                    if (value != null) break block15;
                                    return false;
                                }
                                if (!this.preventChange(relement)) break block16;
                                return false;
                            }
                            Resource valueResource = g.newResource();
                            g.claim(valueResource, Layer0.getInstance((ReadGraph)g).InstanceOf, null, this.valueType);
                            g.claim(element, this.relation, valueResource);
                            g.claimValue(valueResource, value);
                            return true;
                        }
                        if (value != null) break block17;
                        if (!this.preventChange(relement)) break block18;
                        return false;
                    }
                    if (!valueStatement.isAsserted(element)) {
                        g.deny(valueStatement.getObject());
                        return true;
                    }
                    return false;
                }
                Object currentValue = g.getValue(valueStatement.getObject());
                if (!this.equals(currentValue, value)) break block19;
                return false;
            }
            if (!this.preventChange(relement)) break block20;
            return false;
        }
        if (!valueStatement.isAsserted(element)) {
            g.claimValue(valueStatement.getObject(), value);
        } else {
            Resource valueResource = g.newResource();
            g.claim(valueResource, Layer0.getInstance((ReadGraph)g).InstanceOf, null, this.valueType);
            g.claim(element, this.relation, valueResource);
            g.claimValue(valueResource, value);
        }
        return true;
    }

    private Resource getServiceResource(ReadGraph g, StructuralResource element) {
        if (!this.useTypeResource) {
            return element.getResource();
        }
        return element.getTypeResource();
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 instanceof boolean[]) {
            Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof int[]) {
            Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof float[]) {
            Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[]) {
            Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof byte[]) {
            Arrays.equals((byte[])o1, (byte[])o2);
        }
        return o1.equals(o2);
    }
}

