/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.internal;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.backward.IBackwardLinkType;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.backward.IBackwardMappingSchema;
import org.simantics.objmap.exceptions.MappingException;

public class MonotoneBackwardMapping<Domain, Range>
implements IBackwardMapping<Domain, Range> {
    IBackwardMappingSchema<Domain, Range> schema;
    THashMap<Range, Domain> map = new THashMap();

    public MonotoneBackwardMapping(IBackwardMappingSchema<Domain, Range> schema) {
        this.schema = schema;
    }

    @Override
    public Set<Range> getRange() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Domain inverseGet(Range rangeElement) {
        return (Domain)this.map.get(rangeElement);
    }

    @Override
    public Domain inverseMap(WriteGraph graph, Range rangeElement) throws MappingException {
        Domain result = this.inverseGet(rangeElement);
        if (result == null) {
            IBackwardLinkType<Domain, Range> linkType = this.schema.linkTypeOfRangeElement((ReadGraph)graph, rangeElement);
            Domain domainElement = linkType.createDomainElement(graph, rangeElement);
            this.map.put(rangeElement, domainElement);
            linkType.createDomain(graph, this, domainElement, rangeElement);
        }
        return result;
    }
}

