/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.range;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;

public class GetSetValueAccessor<Range, T>
implements IRangeAccessor<Range, T> {
    private Method getter;
    private Method setter;
    private boolean primitive;

    public GetSetValueAccessor(Method getter, Method setter) {
        this.getter = getter;
        this.setter = setter;
        this.primitive = setter.getParameterTypes()[0].isPrimitive();
    }

    @Override
    public T get(Range element) throws MappingException {
        try {
            return (T)this.getter.invoke(element, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
    }

    @Override
    public boolean set(Range element, T value) throws MappingException {
        if (value == null && this.primitive) {
            return false;
        }
        if (this.equal(this.get(element), value)) {
            return false;
        }
        try {
            this.setter.invoke(element, value);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
        return true;
    }

    private boolean equal(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }
}

