/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.domain;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public class MappingUtils {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");

    public static boolean synchronizeStatements(WriteGraph g, Resource subject, Resource predicate, Resource[] objects, boolean deleteExtraObjects) throws DatabaseException {
        Collection currentObjects0 = g.getObjects(subject, predicate);
        Object[] currentObjects = currentObjects0.toArray(new Resource[currentObjects0.size()]);
        Arrays.sort(objects);
        Arrays.sort(currentObjects);
        boolean modified = false;
        int i = 0;
        int j = 0;
        if (currentObjects.length > 0 && objects.length > 0) {
            while (true) {
                int cmp;
                if ((cmp = currentObjects[i].compareTo((Object)objects[j])) < 0) {
                    LOGGER.info((Object)"            remove statement");
                    if (deleteExtraObjects) {
                        g.deny((Resource)currentObjects[i]);
                    } else {
                        g.denyStatement(subject, predicate, (Resource)currentObjects[i]);
                    }
                    modified = true;
                    if (++i < currentObjects.length) continue;
                    break;
                }
                if (cmp > 0) {
                    LOGGER.info((Object)"            add statement");
                    g.claim(subject, predicate, objects[j]);
                    modified = true;
                    if (++j < objects.length) continue;
                    break;
                }
                if (++i >= currentObjects.length || ++j >= objects.length) break;
            }
        }
        while (i < currentObjects.length) {
            if (deleteExtraObjects) {
                g.deny((Resource)currentObjects[i]);
            } else {
                g.denyStatement(subject, predicate, (Resource)currentObjects[i]);
            }
            modified = true;
            ++i;
        }
        while (j < objects.length) {
            g.claim(subject, predicate, objects[j]);
            modified = true;
            ++j;
        }
        return modified;
    }
}

