/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.impl.Link;
import org.simantics.objmap.graph.impl.Mapping;

public class RangeUpdateRequest<Domain, Range>
implements Read<Boolean>,
SyncListener<Boolean> {
    Link<Domain, Range> link;
    IForwardMapping<Domain, Range> map;
    Mapping<Domain, Range> mapping;

    public RangeUpdateRequest(Link<Domain, Range> link, IForwardMapping<Domain, Range> map, Mapping<Domain, Range> mapping) {
        this.link = link;
        this.map = map;
        this.mapping = mapping;
    }

    public Boolean perform(ReadGraph g) throws DatabaseException {
        if (this.map != null) {
            this.link.type.updateRange(g, this.map, this.link.domainElement, this.link.rangeElement);
            this.map = null;
            return Boolean.TRUE;
        }
        if (this.mapping != null) {
            this.mapping.domainModified(this.link);
            this.mapping = null;
            return Boolean.FALSE;
        }
        return null;
    }

    public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
        if (throwable instanceof DatabaseException) {
            throw (DatabaseException)throwable;
        }
        throw new MappingException(throwable);
    }

    public void execute(ReadGraph graph, Boolean result) throws DatabaseException {
    }

    public boolean isDisposed() {
        return this.mapping == null || this.link.removed || this.mapping.isDisposed();
    }
}

