/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.objmap.graph.rules.ValueRule;
import org.simantics.objmap.graph.rules.adapters.IdentityAdapter;
import org.simantics.objmap.graph.rules.adapters.ValueAdapter;
import org.simantics.objmap.graph.rules.domain.RelatedValueAccessor;
import org.simantics.objmap.graph.rules.factory.IGetSetRuleFactory;
import org.simantics.objmap.graph.rules.range.AdaptedRangeAccessor;
import org.simantics.objmap.graph.rules.range.GetSetValueAccessor;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;

public class RelatedGetSetValueRuleFactory<Range>
implements IGetSetRuleFactory<Resource, Range> {
    @Override
    public IBidirectionalMappingRule<Resource, Range> create(ReadGraph g, Annotation annotation, Method getter, Method setter) throws DatabaseException {
        Resource valueType;
        RelatedGetValue getterAnn = (RelatedGetValue)annotation;
        Class<? extends ValueAdapter> adapterClass = getterAnn.adapter();
        IRangeAccessor rangeAccessor = new GetSetValueAccessor(getter, setter);
        if (adapterClass == IdentityAdapter.class) {
            valueType = RelatedGetSetValueRuleFactory.dataTypeOfClass(g, getter.getReturnType());
        } else {
            try {
                ValueAdapter adapter = adapterClass.newInstance();
                rangeAccessor = new AdaptedRangeAccessor(rangeAccessor, adapter);
                valueType = adapter.rangeTypeToDomainType(g, getter.getReturnType());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return new ValueRule(new RelatedValueAccessor(g.getResource(getterAnn.value()), valueType), rangeAccessor);
    }

    @Override
    public boolean isSetter(Annotation getterAnnotation, Annotation annotation) {
        RelatedGetValue getterAnn = (RelatedGetValue)getterAnnotation;
        RelatedSetValue setterAnn = (RelatedSetValue)annotation;
        return getterAnn.value().equals(setterAnn.value());
    }

    public static Resource dataTypeOfClass(ReadGraph g, Class<?> clazz) {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return b.Double;
        }
        if (clazz.equals(String.class)) {
            return b.String;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return b.Integer;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return b.Float;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return b.Boolean;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return b.Long;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return b.Byte;
        }
        if (clazz.equals(double[].class)) {
            return b.DoubleArray;
        }
        if (clazz.equals(int[].class)) {
            return b.IntegerArray;
        }
        if (clazz.equals(byte[].class)) {
            return b.ByteArray;
        }
        if (clazz.equals(float[].class)) {
            return b.FloatArray;
        }
        if (clazz.equals(boolean[].class)) {
            return b.BooleanArray;
        }
        if (clazz.equals(String[].class)) {
            return b.StringArray;
        }
        if (clazz.equals(long[].class)) {
            return b.LongArray;
        }
        System.out.println("Couldn't find a data type for " + clazz);
        return null;
    }
}

