/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;

public class ScenegraphOutlinePage
extends ContentOutlinePage
implements NodeListener {
    private ParentNode<? extends INode> rootNode;
    private Set<INode> toRefresh = new HashSet<INode>();
    private NodeUpdater updater;

    public ScenegraphOutlinePage(ParentNode<? extends INode> rootNode) {
        if (rootNode == null) {
            throw new NullPointerException();
        }
        this.rootNode = rootNode;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.rootNode == null) {
            return;
        }
        TreeViewer viewer = this.getTreeViewer();
        this.createProviders(viewer);
        viewer.setInput(this.rootNode);
        this.listen(this.rootNode);
    }

    protected void createProviders(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ScenegraphContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ScenegraphLabelProvider());
    }

    protected void listen(INode node) {
        node.addListener(this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.listen(n);
            }
        }
    }

    protected void stopListening(INode node) {
        node.removeListener(this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.stopListening(n);
            }
        }
    }

    @Override
    public void propertyChanged(INode node, String id) {
        this.refershViewer(node);
    }

    @Override
    public <T extends INode> void nodeAdded(ParentNode<T> node, INode child, String rel) {
        this.listen(child);
        this.refershViewer(node);
    }

    @Override
    public <T extends INode> void nodeRemoved(ParentNode<T> node, INode child, String rel) {
        this.stopListening(child);
        this.refershViewer(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refershViewer(INode node) {
        if (this.getTreeViewer() == null) {
            return;
        }
        Set<INode> set = this.toRefresh;
        synchronized (set) {
            this.toRefresh.add(node);
            if (this.updater != null) {
                return;
            }
        }
        this.updater = new NodeUpdater();
        Display.getDefault().asyncExec((Runnable)this.updater);
    }

    private class NodeUpdater
    implements Runnable {
        private NodeUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ScenegraphOutlinePage.this.getTreeViewer().getTree().isDisposed()) {
                ScenegraphOutlinePage.this.updater = null;
                return;
            }
            int count = 0;
            while (count < 100) {
                INode node = null;
                Set set = ScenegraphOutlinePage.this.toRefresh;
                synchronized (set) {
                    if (ScenegraphOutlinePage.this.toRefresh.size() > 0) {
                        node = (INode)ScenegraphOutlinePage.this.toRefresh.iterator().next();
                        ScenegraphOutlinePage.this.toRefresh.remove(node);
                    }
                    if (node == null) {
                        ScenegraphOutlinePage.this.updater = null;
                        return;
                    }
                }
                ScenegraphOutlinePage.this.getTreeViewer().refresh((Object)node);
                ++count;
            }
            if (ScenegraphOutlinePage.this.toRefresh.size() > 0) {
                Display.getDefault().asyncExec((Runnable)this);
            }
        }
    }

    public static class ScenegraphContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ParentNode) {
                ParentNode parentNode = (ParentNode)parentElement;
                return parentNode.getNodes().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            if (element instanceof INode) {
                INode node = (INode)element;
                return node.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ParentNode) {
                ParentNode parentNode = (ParentNode)element;
                return parentNode.getNodes().size() > 0;
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ScenegraphLabelProvider
    extends LabelProvider {
    }
}

