/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.utils.Container;

public class AdaptationUtils {
    public static <T> T adaptToSingle(Object o, Class<T> clazz) {
        if (o instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)o;
            if (iss.size() != 1) {
                return null;
            }
            Object element = iss.getFirstElement();
            return AdaptationUtils.adaptToSingle(element, clazz);
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            if (c.size() != 1) {
                return null;
            }
            Object element = c.iterator().next();
            return AdaptationUtils.adaptToSingle(element, clazz);
        }
        if (o instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)o;
            return (T)a.getAdapter(clazz);
        }
        if (clazz.isInstance(o)) {
            return (T)o;
        }
        if (o instanceof Container) {
            Object obj = ((Container)o).get();
            if (obj == o) {
                return null;
            }
            return AdaptationUtils.adaptToSingle(obj, clazz);
        }
        return null;
    }

    public static <T> Collection<T> adaptToCollection(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return Collections.singletonList(o);
        }
        if (o instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)o;
            return AdaptationUtils.adaptToCollection(iss.toArray(), clazz);
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return AdaptationUtils.adaptToCollection(c.toArray(), clazz);
        }
        if (o instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)o;
            return Collections.singletonList(a.getAdapter(clazz));
        }
        if (o instanceof Container) {
            Object obj = ((Container)o).get();
            if (obj == o) {
                return Collections.EMPTY_LIST;
            }
            return AdaptationUtils.adaptToCollection(obj, clazz);
        }
        return Collections.EMPTY_LIST;
    }

    public static <T> Collection<T> adaptToCollection(Object[] arr, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Collection<T> tColl = AdaptationUtils.adaptToCollection(o, clazz);
            for (T t : tColl) {
                if (t == null || result.contains(t)) continue;
                result.add(t);
            }
            ++n2;
        }
        return result;
    }
}

