/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph.structural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.Resource;
import org.simantics.g3d.scenegraph.structural.IComponentNode;
import org.simantics.objmap.structural.IStructuralObject;

public abstract class Connection<T extends IComponentNode>
implements IStructuralObject {
    private List<T> connects = new ArrayList<T>();
    private List<IStructuralObject> ctx = new ArrayList<IStructuralObject>(1);

    public void addConnect(T node) {
        if (!this.connects.contains(node)) {
            this.connects.add(node);
        }
        this.fireChanged(node, true);
    }

    protected void fireChanged(T node, boolean add) {
        for (IComponentNode n : this.connects) {
            n.connectionChanged(this, node, add);
        }
    }

    public Collection<T> getConnected() {
        return this.connects;
    }

    public void removeConnect(T node) {
        this.connects.remove(node);
        this.fireChanged(node, false);
    }

    public void remove() {
        ArrayList<T> toRemove = new ArrayList<T>(this.connects.size());
        toRemove.addAll(this.connects);
        for (IComponentNode node : toRemove) {
            node.removeConnection(this);
        }
    }

    public T getOther(T node) {
        if (this.connects.size() != 2) {
            return null;
        }
        if (((IComponentNode)this.connects.get(0)).equals(node)) {
            return (T)((IComponentNode)this.connects.get(1));
        }
        if (((IComponentNode)this.connects.get(1)).equals(node)) {
            return (T)((IComponentNode)this.connects.get(0));
        }
        return null;
    }

    public void setType(Resource type) {
    }

    public Resource getType() {
        return null;
    }

    public List<IStructuralObject> getContext() {
        return this.ctx;
    }

    public void setContext(List<IStructuralObject> object) {
        this.ctx = object;
    }
}

