/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph.base;

import java.util.ArrayList;
import java.util.List;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.Node;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.utils.datastructures.MapList;

public abstract class ParentNode<T extends INode>
extends Node {
    private MapList<String, T> children = new MapList();

    public synchronized void addNode(String relName, T child) {
        if (child.getParent() != null) {
            child.getParent().removeNode(child.getParentRel(), (INode)child);
        }
        child.setParent(this, relName);
        this.children.add((Object)relName, child);
        this.childrenChanged();
        this.fireNodeAdded((INode)child, relName);
    }

    public final synchronized boolean removeNode(String relName, INode child) {
        if (this.children.remove((Object)relName, (Object)child)) {
            this.fireNodeRemoved(child, relName);
            child.remove();
            child.setParent(null, null);
            return true;
        }
        return false;
    }

    public final synchronized boolean deattachNode(String relName, INode child) {
        if (this.children.remove((Object)relName, (Object)child)) {
            this.fireNodeRemoved(child, relName);
            child.setParent(null, null);
            return true;
        }
        return false;
    }

    public final synchronized boolean removeNodes(String relName) {
        List nodes = this.children.getValues((Object)relName);
        for (INode child : nodes) {
            if (!this.children.remove((Object)relName, (Object)child)) continue;
            this.fireNodeRemoved(child, relName);
            child.remove();
            child.setParent(null, null);
        }
        return nodes.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeNodes() {
        MapList<String, T> mapList = this.children;
        synchronized (mapList) {
            boolean changed = false;
            for (String key : this.children.getKeys()) {
                for (INode child : this.children.getValues((Object)key)) {
                    if (child == null) continue;
                    changed = true;
                    if (child instanceof ParentNode) {
                        ((ParentNode)child).removeNodes();
                    }
                    child.cleanup();
                    child.setParent(null, null);
                }
            }
            this.children.clear();
            if (changed) {
                this.childrenChanged();
            }
        }
    }

    public synchronized List<T> getNodes(String rel) {
        return this.children.getValues((Object)rel);
    }

    public synchronized List<T> getNodes() {
        ArrayList result = new ArrayList();
        for (String s : this.children.getKeys()) {
            result.addAll(this.children.getValues((Object)s));
        }
        return result;
    }

    protected void childrenChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        MapList<String, T> mapList = this.children;
        synchronized (mapList) {
            ArrayList<INode> toRemove = new ArrayList<INode>();
            for (String key : this.children.getKeys()) {
                for (INode child : this.children.getValues((Object)key)) {
                    if (child == null) continue;
                    toRemove.add(child);
                }
            }
            for (INode n : toRemove) {
                n.remove();
            }
            this.children.clear();
            if (toRemove.size() > 0) {
                this.childrenChanged();
            }
            super.remove();
        }
    }

    protected void fireNodeAdded(INode node, String rel) {
        for (NodeListener listener : this.listeners) {
            listener.nodeAdded(this, node, rel);
        }
    }

    protected void fireNodeRemoved(INode node, String rel) {
        for (NodeListener listener : this.listeners) {
            listener.nodeRemoved(this, node, rel);
        }
    }
}

