/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.Activator;
import org.simantics.g3d.math.EulerTools;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.PropertyManipulator;
import org.simantics.g3d.property.ValueProvider;

public class QuatPropertyManipulator
implements PropertyManipulator {
    ValueProvider provider;
    protected Object input;
    EditType type = EditType.QUATERNION;
    EulerTools.Order order;
    boolean editMode;
    Object editValue = null;

    public QuatPropertyManipulator(ValueProvider provider, Object input) {
        this.provider = provider;
        this.input = input;
        String set = Activator.getDefault().getPreferenceStore().getString("orientationPresentationPreference");
        if ("quat".equals(set)) {
            this.type = EditType.QUATERNION;
        } else if ("aa".equals(set)) {
            this.type = EditType.AXIS_ANGLE;
        } else if ("euler".equals(set)) {
            this.type = EditType.EULER;
            String eulerOrder = Activator.getDefault().getPreferenceStore().getString("eulerAngleOrderPreference");
            this.order = EulerTools.Order.valueOf(eulerOrder);
            if (this.order == null) {
                this.order = EulerTools.Order.YXZ;
            }
        }
    }

    @Override
    public String getDescription(int i) {
        switch (this.type) {
            case QUATERNION: {
                if (i == 0) {
                    return "X";
                }
                if (i == 1) {
                    return "Y";
                }
                if (i == 2) {
                    return "Z";
                }
                if (i != 3) break;
                return "W";
            }
            case AXIS_ANGLE: {
                if (i == 0) {
                    return "X";
                }
                if (i == 1) {
                    return "Y";
                }
                if (i == 2) {
                    return "Z";
                }
                if (i != 3) break;
                return "Angle";
            }
            case EULER: {
                if (i > 3) {
                    return null;
                }
                return this.order.toString().substring(i, i + 1);
            }
        }
        return null;
    }

    @Override
    public int getValueCount() {
        switch (this.type) {
            case QUATERNION: {
                return 4;
            }
            case AXIS_ANGLE: {
                return 4;
            }
            case EULER: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public String getValue(int i) {
        try {
            Quat4d q = (Quat4d)this.provider.getValue(this.input);
            double d = 0.0;
            switch (this.type) {
                case QUATERNION: {
                    q = this.editMode ? (Quat4d)this.editValue : new Quat4d(q);
                    if (i == 0) {
                        d = q.x;
                    }
                    if (i == 1) {
                        d = q.y;
                    }
                    if (i == 2) {
                        d = q.z;
                    }
                    if (i != 3) break;
                    d = q.w;
                    break;
                }
                case AXIS_ANGLE: {
                    AxisAngle4d aa;
                    if (this.editMode) {
                        aa = (AxisAngle4d)this.editValue;
                    } else {
                        aa = new AxisAngle4d();
                        aa.set(q);
                    }
                    if (i == 0) {
                        d = aa.x;
                    }
                    if (i == 1) {
                        d = aa.y;
                    }
                    if (i == 2) {
                        d = aa.z;
                    }
                    if (i != 3) break;
                    d = MathTools.radToDeg(aa.angle);
                    break;
                }
                case EULER: {
                    Vector3d aa = this.editMode ? (Vector3d)this.editValue : EulerTools.getEulerFromQuat(this.order, q);
                    if (i == 0) {
                        d = aa.x;
                    }
                    if (i == 1) {
                        d = aa.y;
                    }
                    if (i == 2) {
                        d = aa.z;
                    }
                    d = MathTools.radToDeg(d);
                }
            }
            return Double.toString(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String setValue(String value, int i) {
        try {
            Double d = Double.parseDouble(value);
            Quat4d q = (Quat4d)this.provider.getValue(this.input);
            switch (this.type) {
                case QUATERNION: {
                    q = this.editMode ? (Quat4d)this.editValue : new Quat4d(q);
                    if (i == 0) {
                        q.x = d;
                    }
                    if (i == 1) {
                        q.y = d;
                    }
                    if (i == 2) {
                        q.z = d;
                    }
                    if (i != 3) break;
                    q.w = d;
                    break;
                }
                case AXIS_ANGLE: {
                    AxisAngle4d aa;
                    if (this.editMode) {
                        aa = (AxisAngle4d)this.editValue;
                    } else {
                        aa = new AxisAngle4d();
                        aa.set(q);
                    }
                    if (i == 0) {
                        aa.x = d;
                    }
                    if (i == 1) {
                        aa.y = d;
                    }
                    if (i == 2) {
                        aa.z = d;
                    }
                    if (i == 3) {
                        aa.angle = MathTools.degToRad(d);
                    }
                    q = new Quat4d();
                    MathTools.getQuat(aa, q);
                    break;
                }
                case EULER: {
                    Vector3d e = this.editMode ? (Vector3d)this.editValue : EulerTools.getEulerFromQuat(this.order, q);
                    d = MathTools.degToRad(d);
                    if (i == 0) {
                        e.x = d;
                    }
                    if (i == 1) {
                        e.y = d;
                    }
                    if (i == 2) {
                        e.z = d;
                    }
                    q = EulerTools.getQuatFromEuler(this.order, e);
                }
            }
            q.normalize();
            this.setValue(q);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    protected void setValue(Quat4d q) throws Exception {
        this.provider.setValue(this.input, q);
    }

    private void storeEditValue() {
        try {
            Quat4d q = (Quat4d)this.provider.getValue(this.input);
            switch (this.type) {
                case QUATERNION: {
                    this.editValue = q;
                    break;
                }
                case AXIS_ANGLE: {
                    AxisAngle4d aa = new AxisAngle4d();
                    aa.set(q);
                    this.editValue = aa;
                    break;
                }
                case EULER: {
                    Vector3d e = EulerTools.getEulerFromQuat(this.order, q);
                    this.editValue = e;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(boolean b) {
        this.editMode = b;
        if (this.editMode) {
            this.storeEditValue();
        }
    }

    static enum EditType {
        QUATERNION,
        AXIS_ANGLE,
        EULER;

    }
}

