/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import java.util.Collections;
import java.util.List;
import org.simantics.g3d.property.PropertyTabContributor;
import org.simantics.g3d.property.PropertyTabContributorFactory;
import org.simantics.g3d.property.annotations.PropertyContributor;

public class PropertyTabUtil {
    public static List<PropertyTabContributor> getContributors(Object input) {
        PropertyTabContributorFactory factory = PropertyTabUtil.resolveFactory(input.getClass());
        if (factory == null) {
            return Collections.EMPTY_LIST;
        }
        return factory.getContributors(input);
    }

    private static PropertyTabContributorFactory resolveFactory(Class<?> clazz) {
        Class<?> superClass;
        PropertyContributor contributor = clazz.getAnnotation(PropertyContributor.class);
        if (contributor != null) {
            try {
                return contributor.value().newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            return PropertyTabUtil.resolveFactory(superClass);
        }
        return null;
    }
}

