/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.utils;

import java.util.Collection;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import vtk.vtkMatrix4x4;
import vtk.vtkProp3D;
import vtk.vtkRenderer;

public class vtkUtil {
    public static Ray createMouseRay(vtkRenderer ren1, double x, double y) {
        Point2d screenPos = new Point2d(x, y);
        Point3d worldCoords = vtkUtil.getWorldCoordinates(ren1, screenPos, 0.0);
        Point3d worldCoords2 = vtkUtil.getWorldCoordinates(ren1, screenPos, 1.0);
        Vector3d dir = new Vector3d((Tuple3d)worldCoords2);
        dir.sub((Tuple3d)worldCoords);
        return new Ray(worldCoords, dir);
    }

    public static Point3d getWorldCoordinates(vtkRenderer ren1, Point2d screenPosition, double zPos) {
        ren1.SetDisplayPoint(screenPosition.x, (double)ren1.GetSize()[1] - screenPosition.y, zPos);
        ren1.DisplayToWorld();
        double[] world = ren1.GetWorldPoint();
        return new Point3d(world);
    }

    public static Point2d getScreenCoordinates(vtkRenderer ren1, Tuple3d worldPos) {
        ren1.SetWorldPoint(worldPos.x, worldPos.y, worldPos.z, 0.0);
        ren1.WorldToDisplay();
        double[] screen = ren1.GetDisplayPoint();
        return new Point2d(screen);
    }

    public static Matrix4d getMatrix(vtkMatrix4x4 ptm) {
        Matrix4d mat = new Matrix4d();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                mat.setElement(i, j, ptm.GetElement(i, j));
                ++j;
            }
            ++i;
        }
        return mat;
    }

    public static vtkMatrix4x4 getMatrix(Matrix4d m) {
        vtkMatrix4x4 mat = new vtkMatrix4x4();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                mat.SetElement(i, j, m.getElement(i, j));
                ++j;
            }
            ++i;
        }
        return mat;
    }

    public static void updateTransform(Collection<vtkProp3D> props, Vector3d pos, Quat4d q) {
        AxisAngle4d aa = new AxisAngle4d();
        aa.set(q);
        vtkUtil.updateTransform(props, pos, aa);
    }

    public static void updateTransform(vtkProp3D actor, double[] pos, AxisAngle4d aa) {
        actor.SetOrientation(0.0, 0.0, 0.0);
        actor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
        actor.SetPosition(pos);
    }

    public static void updateTransform(vtkProp3D actor, AxisAngle4d aa) {
        actor.SetOrientation(0.0, 0.0, 0.0);
        actor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
    }

    public static void updateTransform(Collection<vtkProp3D> props, Vector3d pos, AxisAngle4d aa) {
        for (vtkProp3D actor : props) {
            actor.SetOrientation(0.0, 0.0, 0.0);
            actor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
            actor.SetPosition(pos.x, pos.y, pos.z);
        }
    }

    public static void updateTransform(Collection<vtkProp3D> props, Vector3d pos, AxisAngle4d aa, double scale) {
        for (vtkProp3D actor : props) {
            actor.SetOrientation(0.0, 0.0, 0.0);
            actor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
            actor.SetScale(scale);
            actor.SetPosition(pos.x, pos.y, pos.z);
        }
    }

    public static void updateTransform(vtkProp3D actor, Vector3d pos, AxisAngle4d aa, double scale) {
        actor.SetOrientation(0.0, 0.0, 0.0);
        actor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
        actor.SetScale(scale);
        actor.SetPosition(pos.x, pos.y, pos.z);
    }

    public static void updateTransform(vtkProp3D actor, Vector3d pos, AxisAngle4d aa, double scalex, double scaley, double scalez) {
        actor.SetOrientation(0.0, 0.0, 0.0);
        actor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
        actor.SetScale(scalex, scaley, scalez);
        actor.SetPosition(pos.x, pos.y, pos.z);
    }
}

