/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import javax.vecmath.Tuple3d;
import vtk.vtkActor;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkLine;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyLine;
import vtk.vtkUnstructuredGrid;

public class vtkShape {
    public static vtkActor createGridActor(int size, double space, int axes) {
        double s;
        int i;
        int gridCount = 0;
        if ((axes & 1) > 0) {
            ++gridCount;
        }
        if ((axes & 2) > 0) {
            ++gridCount;
        }
        if ((axes & 4) > 0) {
            ++gridCount;
        }
        int pointCount = (size + 1) * 2 * 2 * gridCount;
        vtkPoints linePoints = new vtkPoints();
        linePoints.SetNumberOfPoints(pointCount);
        double max = space * (double)size * 0.5;
        double min = -max;
        int base = 0;
        if ((axes & 1) > 0) {
            i = 0;
            while (i <= size) {
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, 0.0, s, min);
                linePoints.InsertPoint(base + i * 2 + 1, 0.0, s, max);
                if (++i > size) break;
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, 0.0, s, max);
                linePoints.InsertPoint(base + i * 2 + 1, 0.0, s, min);
                ++i;
            }
            base += (size + 1) * 2;
            i = 0;
            while (i <= size) {
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, 0.0, max, s);
                linePoints.InsertPoint(base + i * 2 + 1, 0.0, min, s);
                if (++i > size) break;
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, 0.0, min, s);
                linePoints.InsertPoint(base + i * 2 + 1, 0.0, max, s);
                ++i;
            }
            base += (size + 1) * 2;
        }
        if ((axes & 4) > 0) {
            i = 0;
            while (i <= size) {
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, s, min, 0.0);
                linePoints.InsertPoint(base + i * 2 + 1, s, max, 0.0);
                if (++i > size) break;
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, s, max, 0.0);
                linePoints.InsertPoint(base + i * 2 + 1, s, min, 0.0);
                ++i;
            }
            base += (size + 1) * 2;
            i = 0;
            while (i <= size) {
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, max, s, 0.0);
                linePoints.InsertPoint(base + i * 2 + 1, min, s, 0.0);
                if (++i > size) break;
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, min, s, 0.0);
                linePoints.InsertPoint(base + i * 2 + 1, max, s, 0.0);
                ++i;
            }
            base += (size + 1) * 2;
        }
        if ((axes & 2) > 0) {
            i = 0;
            while (i <= size) {
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, s, 0.0, min);
                linePoints.InsertPoint(base + i * 2 + 1, s, 0.0, max);
                if (++i > size) break;
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, s, 0.0, max);
                linePoints.InsertPoint(base + i * 2 + 1, s, 0.0, min);
                ++i;
            }
            base += (size + 1) * 2;
            i = 0;
            while (i <= size) {
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, max, 0.0, s);
                linePoints.InsertPoint(base + i * 2 + 1, min, 0.0, s);
                if (++i > size) break;
                s = min + (double)i * space;
                linePoints.InsertPoint(base + i * 2, min, 0.0, s);
                linePoints.InsertPoint(base + i * 2 + 1, max, 0.0, s);
                ++i;
            }
            base += (size + 1) * 2;
        }
        vtkPolyLine aLine = new vtkPolyLine();
        aLine.GetPointIds().SetNumberOfIds(pointCount);
        int i2 = 0;
        while (i2 < pointCount) {
            aLine.GetPointIds().SetId(i2, i2);
            ++i2;
        }
        vtkUnstructuredGrid aLineGrid = new vtkUnstructuredGrid();
        aLineGrid.Allocate(pointCount, pointCount);
        aLineGrid.InsertNextCell(aLine.GetCellType(), aLine.GetPointIds());
        aLineGrid.SetPoints(linePoints);
        vtkDataSetMapper aLineMapper = new vtkDataSetMapper();
        aLineMapper.SetInput((vtkDataSet)aLineGrid);
        vtkActor aLineActor = new vtkActor();
        aLineActor.SetMapper((vtkMapper)aLineMapper);
        linePoints.Delete();
        aLine.GetPointIds().Delete();
        aLine.Delete();
        aLineGrid.Delete();
        aLineMapper.Delete();
        aLineActor.GetProperty().SetColor(0.0, 0.0, 0.0);
        aLineActor.GetProperty().Delete();
        return aLineActor;
    }

    public static vtkActor createLineActor(Tuple3d p1, Tuple3d p2) {
        vtkPoints linePoints = new vtkPoints();
        linePoints.SetNumberOfPoints(2);
        linePoints.InsertPoint(0, p1.x, p1.y, p1.z);
        linePoints.InsertPoint(1, p2.x, p2.y, p2.z);
        vtkLine aLine = new vtkLine();
        aLine.GetPointIds().SetId(0, 0);
        aLine.GetPointIds().SetId(1, 1);
        vtkUnstructuredGrid aLineGrid = new vtkUnstructuredGrid();
        aLineGrid.Allocate(1, 1);
        aLineGrid.InsertNextCell(aLine.GetCellType(), aLine.GetPointIds());
        aLineGrid.SetPoints(linePoints);
        vtkDataSetMapper aLineMapper = new vtkDataSetMapper();
        aLineMapper.SetInput((vtkDataSet)aLineGrid);
        vtkActor aLineActor = new vtkActor();
        aLineActor.SetMapper((vtkMapper)aLineMapper);
        linePoints.Delete();
        aLine.GetPointIds().Delete();
        aLine.Delete();
        aLineGrid.Delete();
        aLineMapper.Delete();
        return aLineActor;
    }
}

