/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import javax.vecmath.Vector3d;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.shape.Mesh;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkDataObject;
import vtk.vtkIdList;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;
import vtk.vtkTriangle;
import vtk.vtkUnsignedCharArray;

public class MeshActor
extends vtkActor {
    public void setMesh(Mesh mesh) {
        boolean computeNormals;
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        vtkPolyData polyData = new vtkPolyData();
        polyData.Allocate(mesh.getIndices().size() / 3, mesh.getIndices().size() / 3);
        vtkTriangle triangle = new vtkTriangle();
        vtkIdList list = triangle.GetPointIds();
        int i = 0;
        while (i < mesh.getIndices().size()) {
            list.SetId(0, ((Integer)mesh.getIndices().get(i)).intValue());
            list.SetId(1, ((Integer)mesh.getIndices().get(i + 1)).intValue());
            list.SetId(2, ((Integer)mesh.getIndices().get(i + 2)).intValue());
            polyData.InsertNextCell(triangle.GetCellType(), list);
            i += 3;
        }
        list.Delete();
        triangle.Delete();
        vtkPoints points = new vtkPoints();
        int i2 = 0;
        while (i2 < mesh.getVertices().size()) {
            Vector3d p = (Vector3d)mesh.getVertices().get(i2);
            points.InsertPoint(i2, p.x, p.y, p.z);
            ++i2;
        }
        polyData.SetPoints(points);
        points.Delete();
        if (mesh.getColors() != null) {
            vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
            colors.SetName("Colors");
            colors.SetNumberOfComponents(3);
            colors.SetNumberOfTuples(mesh.getColors().size());
            int i3 = 0;
            while (i3 < mesh.getColors().size()) {
                Color4d c = (Color4d)mesh.getColors().get(i3);
                colors.InsertTuple3(i3, 255.0 * c.x, 255.0 * c.y, 255.0 * c.z);
                ++i3;
            }
            polyData.GetPointData().AddArray((vtkAbstractArray)colors);
            colors.Delete();
        }
        if (computeNormals = true) {
            vtkPolyDataNormals normals = new vtkPolyDataNormals();
            normals.SetInput((vtkDataObject)polyData);
            mapper.SetInputConnection(normals.GetOutputPort());
            normals.GetOutputPort().Delete();
            normals.Delete();
        } else {
            mapper.SetInput(polyData);
        }
        if (mesh.getColors() != null) {
            mapper.ScalarVisibilityOn();
            mapper.SetScalarModeToUsePointFieldData();
            mapper.SelectColorArray("Colors");
        }
        this.SetMapper((vtkMapper)mapper);
        mapper.Delete();
        polyData.GetPointData().Delete();
        polyData.Delete();
    }
}

