/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.vtk.shape.IvtkVisualObject;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkLineSource;
import vtk.vtkLinearTransform;
import vtk.vtkMapper;
import vtk.vtkMatrix4x4;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderer;
import vtk.vtkTextActor;
import vtk.vtkTubeFilter;

public class DualHeadArrowActor
extends vtkAssembly
implements IvtkVisualObject {
    private vtkRenderer ren;
    private Vector3d axisDir = new Vector3d(1.0, 0.0, 0.0);
    private vtkTextActor tactor;
    private vtkActor tubeActor;
    private vtkActor coneActor;
    private vtkActor coneActor2;
    private boolean rendered = false;
    double[] mat = new double[16];
    Matrix4d m = new Matrix4d();

    public DualHeadArrowActor(vtkRenderer _ren, String label) {
        this.ren = _ren;
        this.createAxis(label);
    }

    public DualHeadArrowActor(vtkRenderer _ren, String label, Vector3d dir) {
        this.ren = _ren;
        this.axisDir = dir;
        if (dir.lengthSquared() < MathTools.NEAR_ZERO) {
            throw new IllegalArgumentException("Direction vector length must mer larger than zero");
        }
        this.createAxis(label);
    }

    public void createAxis(String label) {
        double coneScale = 0.3 * this.axisDir.length();
        Vector3d coneOffset = new Vector3d(this.axisDir);
        coneOffset.normalize();
        coneOffset.scale(coneScale * 0.5);
        vtkLineSource line = new vtkLineSource();
        line.SetPoint1(coneOffset.x, coneOffset.y, coneOffset.z);
        line.SetPoint2(this.axisDir.x - coneOffset.x, this.axisDir.y - coneOffset.y, this.axisDir.z - coneOffset.z);
        this.tactor = new vtkTextActor();
        this.tactor.SetInput(label);
        this.tactor.SetTextScaleModeToNone();
        this.tactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.tactor.GetTextProperty().ShadowOff();
        this.tactor.GetTextProperty().ItalicOff();
        this.tactor.GetTextProperty().BoldOff();
        this.tactor.GetTextProperty().Delete();
        this.tactor.SetMaximumLineHeight(0.25);
        this.tactor.SetPickable(0);
        vtkTubeFilter tube = new vtkTubeFilter();
        tube.SetInput((vtkDataObject)line.GetOutput());
        tube.SetRadius(0.05 * this.axisDir.length());
        tube.SetNumberOfSides(8);
        vtkPolyDataMapper tubeMapper = new vtkPolyDataMapper();
        tubeMapper.SetInput(tube.GetOutput());
        this.tubeActor = new vtkActor();
        this.tubeActor.SetMapper((vtkMapper)tubeMapper);
        this.tubeActor.PickableOff();
        int coneRes = 12;
        vtkConeSource cone = new vtkConeSource();
        cone.SetResolution(coneRes);
        vtkPolyDataMapper coneMapper = new vtkPolyDataMapper();
        coneMapper.SetInput(cone.GetOutput());
        this.coneActor = new vtkActor();
        this.coneActor.SetMapper((vtkMapper)coneMapper);
        this.coneActor.GetProperty().SetColor(1.0, 0.0, 0.0);
        this.coneActor.SetScale(coneScale, coneScale, coneScale);
        this.coneActor.SetPosition(this.axisDir.x - coneOffset.x, this.axisDir.y - coneOffset.y, this.axisDir.z - coneOffset.z);
        this.coneActor.SetPickable(0);
        AxisAngle4d aa = MathTools.createRotation((Vector3d)new Vector3d(1.0, 0.0, 0.0), (Vector3d)this.axisDir);
        if (aa != null) {
            this.coneActor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
        }
        this.coneActor2 = new vtkActor();
        this.coneActor2.SetMapper((vtkMapper)coneMapper);
        this.coneActor2.GetProperty().SetColor(1.0, 0.0, 0.0);
        this.coneActor2.SetScale(coneScale, coneScale, coneScale);
        this.coneActor2.SetPosition(coneOffset.x, coneOffset.y, coneOffset.z);
        this.coneActor2.SetPickable(0);
        aa = MathTools.createRotation((Vector3d)new Vector3d(-1.0, 0.0, 0.0), (Vector3d)this.axisDir);
        if (aa != null) {
            this.coneActor2.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
        }
        this.AddPart((vtkProp3D)this.tubeActor);
        this.AddPart((vtkProp3D)this.coneActor);
        this.AddPart((vtkProp3D)this.coneActor2);
        tube.GetOutput().Delete();
        cone.GetOutput().Delete();
        line.GetOutput().Delete();
        tubeMapper.Delete();
        tube.Delete();
        cone.Delete();
        line.Delete();
        coneMapper.Delete();
        this.coneActor.GetProperty().Delete();
        this.coneActor2.GetProperty().Delete();
    }

    @Override
    public void addToRenderer() {
        if (this.rendered) {
            return;
        }
        this.rendered = true;
        this.ren.AddActor2D((vtkProp)this.tactor);
        this.ren.AddActor((vtkProp)this);
    }

    @Override
    public void removeFromRenderer() {
        if (!this.rendered) {
            return;
        }
        this.rendered = false;
        this.ren.RemoveActor2D((vtkProp)this.tactor);
        this.ren.RemoveActor((vtkProp)this);
    }

    @Override
    public boolean isRendered() {
        return this.rendered;
    }

    public void setAxesVisibility(boolean ison) {
        this.SetVisibility(ison ? 1 : 0);
        this.tactor.SetVisibility(ison ? 1 : 0);
    }

    public void setLabelVisibility(boolean ison) {
        this.tactor.SetVisibility(ison ? 1 : 0);
    }

    private void updateTextLoc() {
        this.tactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.GetMatrix(this.mat);
        MathTools.set((Matrix4d)this.m, (double[])this.mat);
        Point3d p = new Point3d(this.axisDir.x * 0.5, this.axisDir.y * 0.5, this.axisDir.z * 0.5);
        this.m.transform(p);
        this.tactor.GetPositionCoordinate().SetValue(p.x, p.y, p.z);
        this.tactor.GetPositionCoordinate().Delete();
    }

    public void SetPickable(int id0) {
        super.SetPickable(id0);
        this.tubeActor.SetPickable(id0);
        this.coneActor.SetPickable(id0);
        this.coneActor2.SetPickable(id0);
    }

    public void SetOrientation(double id0, double id1, double id2) {
        super.SetOrientation(id0, id1, id2);
        this.updateTextLoc();
    }

    public void RotateWXYZ(double id0, double id1, double id2, double id3) {
        super.RotateWXYZ(id0, id1, id2, id3);
        this.updateTextLoc();
    }

    public void SetPosition(double[] id0) {
        super.SetPosition(id0);
        this.updateTextLoc();
    }

    public void SetPosition(double id0, double id1, double id2) {
        super.SetPosition(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetOrientation(double[] id0) {
        super.SetOrientation(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0, double id1, double id2) {
        super.SetScale(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetScale(double[] id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetColor(double r, double g, double b) {
        this.coneActor.GetProperty().SetColor(r, g, b);
        this.coneActor2.GetProperty().SetColor(r, g, b);
        this.tubeActor.GetProperty().SetColor(r, g, b);
        this.coneActor.GetProperty().Delete();
        this.coneActor2.GetProperty().Delete();
        this.tubeActor.GetProperty().Delete();
    }

    public void SetTextColor(double r, double g, double b) {
        this.tactor.GetTextProperty().SetColor(r, g, b);
        this.tactor.GetTextProperty().Delete();
    }

    public void SetUserMatrix(vtkMatrix4x4 id0) {
        super.SetUserMatrix(id0);
        this.updateTextLoc();
    }

    public void SetUserTransform(vtkLinearTransform id0) {
        super.SetUserTransform(id0);
        this.updateTextLoc();
    }

    public void Delete() {
        this.ren.RemoveActor((vtkProp)this.tactor);
        this.ren.RemoveActor((vtkProp)this.tubeActor);
        this.ren.RemoveActor((vtkProp)this.coneActor);
        this.ren.RemoveActor((vtkProp)this.coneActor2);
        this.tactor.Delete();
        this.tubeActor.Delete();
        this.coneActor.Delete();
        this.coneActor2.Delete();
        super.Delete();
    }

    public void dispose() {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DualHeadArrowActor.this.removeFromRenderer();
                DualHeadArrowActor.this.Delete();
            }
        });
    }

    @Override
    public vtkProp3D getVtkProp() {
        return this;
    }
}

