/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.handlers;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.g3d.vtk.common.InteractiveVtkPanel;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ParallelPerspectiveHandler
extends AbstractHandler {
    private Map<InteractiveVtkPanel, Vector3d> cameraPos = new HashMap<InteractiveVtkPanel, Vector3d>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command = event.getCommand();
        boolean oldValue = HandlerUtil.toggleCommandState((Command)command);
        final boolean activate = !oldValue;
        IEditorPart ap = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        final InteractiveVtkPanel panel = (InteractiveVtkPanel)((Object)ap.getAdapter(InteractiveVtkPanel.class));
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (activate) {
                    Vector3d focal = new Vector3d(panel.GetRenderer().GetActiveCamera().GetFocalPoint());
                    Vector3d pos = new Vector3d(panel.GetRenderer().GetActiveCamera().GetPosition());
                    ParallelPerspectiveHandler.this.cameraPos.put(panel, pos);
                    Vector3d dir = new Vector3d(pos);
                    dir.sub((Tuple3d)focal);
                    dir.normalize();
                    dir.scale(100.0);
                    dir.add((Tuple3d)focal);
                    panel.GetRenderer().GetActiveCamera().SetPosition(dir.x, dir.y, dir.z);
                    panel.GetRenderer().GetActiveCamera().SetParallelProjection(1);
                    panel.GetRenderer().ResetCameraClippingRange();
                } else {
                    panel.GetRenderer().GetActiveCamera().SetParallelProjection(0);
                    Vector3d pos = (Vector3d)ParallelPerspectiveHandler.this.cameraPos.get((Object)panel);
                    if (pos != null) {
                        panel.GetRenderer().GetActiveCamera().SetPosition(pos.x, pos.y, pos.z);
                    }
                    panel.GetRenderer().ResetCameraClippingRange();
                }
                panel.UpdateLight();
                panel.repaint();
            }
        });
        return null;
    }
}

