/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.NodeHighlighter;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkActor;
import vtk.vtkAlgorithm;
import vtk.vtkAlgorithmOutput;
import vtk.vtkFeatureEdges;
import vtk.vtkMapper;
import vtk.vtkPanel;
import vtk.vtkProp;
import vtk.vtkProperty;

public class SelectionHighlighter<E extends IG3DNode>
implements ISelectionChangedListener {
    vtkPanel panel;
    VTKNodeMap<E> nodeMap;
    List<IG3DNode> selectedNodes = new ArrayList<IG3DNode>();
    List<vtkActor> selectedActors = new ArrayList<vtkActor>();
    NodeHighlighter.HighlightObjectType type = NodeHighlighter.HighlightObjectType.Node;

    public SelectionHighlighter(vtkPanel panel, VTKNodeMap<E> nodeMap) {
        this.panel = panel;
        this.nodeMap = nodeMap;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        final ISelection s = event.getSelection();
        if (Thread.currentThread().equals(AWTThread.getThreadAccess().getThread())) {
            this.highlight(s);
        } else {
            ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    SelectionHighlighter.this.highlight(s);
                    SelectionHighlighter.this.panel.Render();
                }
            });
        }
    }

    protected void hilight(E node, NodeHighlighter.HighlightEventType type) {
        if (node instanceof NodeHighlighter) {
            ((NodeHighlighter)node).highlight(type);
            return;
        }
        if (type == NodeHighlighter.HighlightEventType.Selection) {
            this.setSelectedColor(node);
        } else if (type == NodeHighlighter.HighlightEventType.ClearSelection) {
            this.setDefaultColor(node);
        }
    }

    protected void hilight(vtkActor actor, NodeHighlighter.HighlightEventType type) {
        if (type == NodeHighlighter.HighlightEventType.Selection) {
            this.setColor(actor, false, new double[]{1.0, 0.0, 0.0});
            this.setColor(actor, true, new double[]{1.0, 0.0, 1.0});
        } else if (type == NodeHighlighter.HighlightEventType.ClearSelection) {
            this.setColor(actor, false, new double[]{1.0, 1.0, 0.0});
            this.setColor(actor, true, new double[]{0.0, 0.0, 0.0});
        }
    }

    protected void highlight(ISelection s) {
        this.highlight(s, NodeHighlighter.HighlightEventType.Selection, NodeHighlighter.HighlightEventType.ClearSelection);
    }

    protected void highlight(ISelection s, NodeHighlighter.HighlightEventType apply, NodeHighlighter.HighlightEventType clear) {
        boolean changed = false;
        if (this.type == NodeHighlighter.HighlightObjectType.Node) {
            List<IG3DNode> currentSelectedNodes = AdaptationUtils.adaptToCollection((Object)s, IG3DNode.class);
            if (currentSelectedNodes.size() == 0) {
                Collection currentSelectedActors = AdaptationUtils.adaptToCollection((Object)s, vtkProp.class);
                currentSelectedNodes = this.getSelectedNodes(currentSelectedActors);
            }
            for (IG3DNode node : this.selectedNodes) {
                if (currentSelectedNodes.contains(node)) continue;
                this.hilight(node, clear);
                changed = true;
            }
            for (IG3DNode node : currentSelectedNodes) {
                if (this.selectedNodes.contains(node)) continue;
                this.hilight(node, apply);
                changed = true;
            }
            this.selectedNodes.clear();
            this.selectedNodes.addAll(currentSelectedNodes);
        } else {
            Collection currentSelectedActors = AdaptationUtils.adaptToCollection((Object)s, vtkActor.class);
            for (vtkActor act : this.selectedActors) {
                if (currentSelectedActors.contains(act)) continue;
                this.hilight(act, clear);
                changed = true;
            }
            for (vtkActor act : currentSelectedActors) {
                if (this.selectedActors.contains(act)) continue;
                this.hilight(act, apply);
                changed = true;
            }
            this.selectedActors.clear();
            this.selectedActors.addAll(currentSelectedActors);
        }
        if (changed) {
            this.panel.repaint();
        }
    }

    protected List<IG3DNode> getSelectedNodes(Collection<vtkProp> selectedActors) {
        ArrayList<IG3DNode> currentSelectedNodes = new ArrayList<IG3DNode>();
        for (vtkProp a : selectedActors) {
            INode node = this.nodeMap.getNode(a);
            if (node == null || !(node instanceof IG3DNode) || currentSelectedNodes.contains(node)) continue;
            currentSelectedNodes.add((IG3DNode)node);
        }
        return currentSelectedNodes;
    }

    protected void setDefaultColor(E node) {
        double[] color = new double[]{1.0, 1.0, 0.0};
        this.setColor(node, false, color);
    }

    protected void setSelectedColor(E node) {
        double[] color = new double[]{1.0, 0.0, 0.0};
        this.setColor(node, false, color);
    }

    protected void setColor(E node, boolean edge, double[] color) {
        for (vtkProp prop : this.nodeMap.getRenderObjects((INode)node)) {
            if (!(prop instanceof vtkActor)) continue;
            vtkActor act = (vtkActor)prop;
            this.setColor(act, edge, color);
        }
    }

    protected void setColor(vtkActor act, boolean edge, double[] color) {
        vtkMapper mapper = act.GetMapper();
        vtkAlgorithmOutput out = mapper.GetInputConnection(0, 0);
        vtkAlgorithm producer = out.GetProducer();
        boolean isEdge = producer instanceof vtkFeatureEdges;
        producer.Delete();
        if (isEdge == edge) {
            vtkProperty property = act.GetProperty();
            property.SetColor(color);
            property.Delete();
        }
        out.Delete();
        mapper.Delete();
    }
}

