/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.db.Resource;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.common.VTKSelectionItem;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.structural.StructuralResource;
import vtk.vtkProp;

public class NodeSelectionProvider2<DBObject, JavaObject>
implements ISelectionProvider,
ISelectionChangedListener,
ISelectionListener {
    private ISelection selection = new StructuredSelection();
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    List<IG3DNode> selectedNodes = new ArrayList<IG3DNode>();
    List<VTKSelectionItem<DBObject>> selectedItems = new ArrayList<VTKSelectionItem<DBObject>>();
    IEditorPart part;
    IMapping<DBObject, JavaObject> mapping;
    VTKNodeMap nodeMap;

    public NodeSelectionProvider2(IEditorPart part, IMapping<DBObject, JavaObject> mapping, VTKNodeMap nodeMap) {
        this.part = part;
        this.mapping = mapping;
        this.nodeMap = nodeMap;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection s = event.getSelection();
        this.processSelection(s);
        this.fireSelectionChanged(event.getSource());
    }

    private void processSelection(ISelection s) {
        this.selectedNodes.clear();
        this.selectedItems.clear();
        Collection selectedActors = AdaptationUtils.adaptToCollection((Object)s, vtkProp.class);
        if (selectedActors.size() > 0) {
            for (vtkProp a : selectedActors) {
                IG3DNode node = (IG3DNode)this.nodeMap.getNode(a);
                if (node == null) continue;
                if (!this.selectedNodes.contains(node)) {
                    this.selectedNodes.add(node);
                }
                Object r = this.mapping.inverseGet((Object)node);
                this.selectedItems.add(new VTKSelectionItem<Object>(a, node, r));
            }
        } else {
            Collection selectedNds = AdaptationUtils.adaptToCollection((Object)s, IG3DNode.class);
            for (INode node : selectedNds) {
                if (!this.selectedNodes.contains(node)) {
                    this.selectedNodes.add((IG3DNode)node);
                }
                Object r = this.mapping.inverseGet((Object)node);
                this.selectedItems.add(new VTKSelectionItem<Object>(null, (IG3DNode)node, r));
            }
        }
        this.selection = new StructuredSelection(this.selectedItems);
    }

    private void fireSelectionChanged(Object source) {
        SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)source, this.selection);
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(evt);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this.part) {
            return;
        }
        this.processSelection(selection);
    }

    public List<IG3DNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public List<DBObject> getSelectedResources() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (VTKSelectionItem<DBObject> i : this.selectedItems) {
            Object r = i.getAdapter(Resource.class);
            if (r == null) {
                r = i.getAdapter(StructuralResource.class);
            }
            if (r == null || list.contains(r)) continue;
            list.add(r);
        }
        return list;
    }

    protected INode getNode(DBObject r) {
        return (INode)this.mapping.get(r);
    }
}

