/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.vtk.common.InteractiveVtkPanel;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.IMappingListener;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ExceptionUtils;
import vtk.vtkProp;

public abstract class AbstractVTKNodeMap<E extends IG3DNode>
implements VTKNodeMap<E>,
IMappingListener,
RenderListener,
NodeListener {
    private static final boolean DEBUG = false;
    protected Session session;
    protected IMapping<Object, E> mapping;
    protected InteractiveVtkPanel panel;
    protected MapList<E, vtkProp> nodeToActor = new MapList();
    protected Map<vtkProp, E> actorToNode = new HashMap<vtkProp, E>();
    protected ParentNode<E> rootNode;
    private boolean changeTracking = true;
    protected Object syncMutex = new Object();
    private List<Pair<E, String>> added = new ArrayList<Pair<E, String>>();
    private List<Pair<E, String>> removed = new ArrayList<Pair<E, String>>();
    private MapSet<E, String> updated = new MapSet.Hash();
    private boolean rangeModified = false;
    private boolean graphUpdates = false;
    private Set<E> graphModified = new HashSet();
    private boolean requestCommit = false;
    List<Pair<E, String>> rem = new ArrayList<Pair<E, String>>();
    List<Pair<E, String>> add = new ArrayList<Pair<E, String>>();
    MapSet<E, String> mod = new MapSet.Hash();
    Set<E> propagation = new HashSet();
    Stack<E> stack = new Stack();
    private List<NodeListener> nodeListeners = new ArrayList<NodeListener>();

    public AbstractVTKNodeMap(Session session, IMapping<Object, E> mapping, InteractiveVtkPanel panel, ParentNode<E> rootNode) {
        this.session = session;
        this.mapping = mapping;
        this.panel = panel;
        this.rootNode = rootNode;
        panel.addListener(this);
        mapping.addMappingListener((IMappingListener)this);
        rootNode.addListener((NodeListener)this);
    }

    protected abstract void addActor(E var1);

    protected abstract void removeActor(E var1);

    protected abstract void updateActor(E var1, Set<String> var2);

    public void repaint() {
        this.panel.repaint();
    }

    public void populate() {
        for (IG3DNode node : this.rootNode.getNodes()) {
            this.receiveAdd(node, node.getParentRel(), true);
        }
        this.repaint();
    }

    public E getNode(vtkProp prop) {
        return (E)((IG3DNode)this.actorToNode.get(prop));
    }

    public Collection<vtkProp> getRenderObjects(IG3DNode node) {
        return this.nodeToActor.getValues((Object)node);
    }

    public ParentNode<E> getRootNode() {
        return this.rootNode;
    }

    public boolean isChangeTracking() {
        return this.changeTracking;
    }

    public void setChangeTracking(boolean enabled) {
        this.changeTracking = enabled;
    }

    public void updateRenderObjectsFor(IG3DNode node) {
        ArrayList<vtkProp> toDelete = new ArrayList<vtkProp>();
        for (vtkProp prop : this.nodeToActor.getValues((Object)node)) {
            if (prop.GetVTKId() != 0L) {
                this.panel.GetRenderer().RemoveActor(prop);
                toDelete.add(prop);
            }
            this.actorToNode.remove(prop);
        }
        this.nodeToActor.remove((Object)node);
        Collection<vtkProp> coll = this.getActors(node);
        if (coll == null) {
            return;
        }
        for (vtkProp prop : coll) {
            this.nodeToActor.add((Object)node, (Object)prop);
            this.actorToNode.put(prop, node);
            toDelete.remove(prop);
        }
        for (vtkProp p : toDelete) {
            p.Delete();
        }
    }

    protected abstract Collection<vtkProp> getActors(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAdd(E node, String id, boolean db) {
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.added) {
                if (!((IG3DNode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking) {
                this.mapping.rangeModified((Object)((IG3DNode)node.getParent()));
            }
            this.added.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.panel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveRemove(E node, String id, boolean db) {
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.removed) {
                if (!((IG3DNode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking && !db) {
                this.mapping.rangeModified((Object)((IG3DNode)node.getParent()));
            }
            this.removed.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.panel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveUpdate(E node, String id, boolean db) {
        Object object = this.syncMutex;
        synchronized (object) {
            if (this.changeTracking && !db) {
                this.mapping.rangeModified(node);
            }
            this.updated.add(node, (Object)id);
            this.rangeModified = true;
        }
        this.panel.repaint();
    }

    public void commit() {
        this.requestCommit = true;
    }

    protected void doCommit() {
        this.session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                AbstractVTKNodeMap.this.commit(graph);
            }
        }, (Consumer)new Callback<DatabaseException>(){

            public void run(DatabaseException parameter) {
                if (parameter != null) {
                    ExceptionUtils.logAndShowError((String)"Cannot commit editor changes", (Throwable)parameter);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(WriteGraph graph) throws DatabaseException {
        Object object = this.syncMutex;
        synchronized (object) {
            this.graphUpdates = true;
            this.mapping.updateDomain(graph);
            this.graphUpdates = false;
        }
    }

    public void domainModified() {
        if (this.graphUpdates) {
            return;
        }
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                AbstractVTKNodeMap.this.update(graph);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ReadGraph graph) throws DatabaseException {
        Object object = this.syncMutex;
        synchronized (object) {
            this.graphUpdates = true;
            for (Object domainObject : this.mapping.getDomainModified()) {
                IG3DNode rangeObject = (IG3DNode)this.mapping.get(domainObject);
                if (rangeObject == null) continue;
                this.graphModified.add(rangeObject);
            }
            this.mapping.updateRange(graph);
            this.graphModified.clear();
            this.graphUpdates = false;
        }
        if (this.mapping.isRangeModified()) {
            this.commit();
        }
    }

    public void rangeModified() {
    }

    public void postRender() {
        if (this.requestCommit && !this.rangeModified) {
            this.requestCommit = false;
            this.doCommit();
        }
    }

    public synchronized void preRender() {
        this.updateCycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCycle() {
        Object ids;
        this.rem.clear();
        this.add.clear();
        this.mod.clear();
        this.propagation.clear();
        Object object = this.syncMutex;
        synchronized (object) {
            this.rem.addAll(this.removed);
            this.add.addAll(this.added);
            for (Object e : this.updated.getKeys()) {
                for (String s : this.updated.getValues(e)) {
                    this.mod.add(e, (Object)s);
                }
            }
            this.removed.clear();
            this.added.clear();
            this.updated.clear();
        }
        for (Pair pair : this.rem) {
            this.stopListening((INode)pair.first);
            this.removeActor((IG3DNode)pair.first);
        }
        for (Pair pair : this.add) {
            this.addActor((IG3DNode)pair.first);
            this.listen((INode)pair.first);
        }
        for (IG3DNode iG3DNode : this.mod.getKeys()) {
            ids = this.mod.getValues((Object)iG3DNode);
            if (!ids.contains("http://www.simantics.org/G3D-0.1/hasPosition") && !ids.contains("http://www.simantics.org/G3D-0.1/hasOrientation") || this.propagation.contains(iG3DNode)) continue;
            this.propagation.add(iG3DNode);
        }
        if (this.propagation.size() > 0) {
            this.stack.clear();
            this.stack.addAll(this.propagation);
            this.propagation.clear();
            while (!this.stack.isEmpty()) {
                IG3DNode iG3DNode = (IG3DNode)this.stack.pop();
                if (this.propagation.contains(iG3DNode)) continue;
                this.propagation.add(iG3DNode);
                for (NodeListener l : iG3DNode.getListeners()) {
                    if (l == this) continue;
                    l.propertyChanged((INode)iG3DNode, "http://www.simantics.org/G3D-0.1/hasWorldPosition");
                }
                if (!(iG3DNode instanceof ParentNode)) continue;
                this.stack.addAll(((ParentNode)iG3DNode).getNodes());
            }
        }
        for (IG3DNode iG3DNode : this.mod.getKeys()) {
            ids = this.mod.getValues((Object)iG3DNode);
            this.updateActor(iG3DNode, (Set<String>)ids);
        }
        for (Pair pair : this.rem) {
            for (NodeListener l : this.nodeListeners) {
                l.nodeRemoved(null, (INode)pair.first, (String)pair.second);
            }
        }
        for (Pair pair : this.add) {
            for (NodeListener l : this.nodeListeners) {
                l.nodeAdded(((IG3DNode)pair.first).getParent(), (INode)pair.first, (String)pair.second);
            }
        }
        for (IG3DNode iG3DNode : this.mod.getKeys()) {
            for (NodeListener l : this.nodeListeners) {
                for (String s : this.mod.getValues((Object)iG3DNode)) {
                    l.propertyChanged((INode)iG3DNode, s);
                }
            }
        }
        Object object2 = this.syncMutex;
        synchronized (object2) {
            if (this.added.isEmpty() && this.removed.isEmpty() && this.updated.getKeys().size() == 0) {
                this.rangeModified = false;
            }
        }
    }

    private void listen(INode node) {
        node.addListener((NodeListener)this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.listen(n);
            }
        }
    }

    private void stopListening(INode node) {
        node.removeListener((NodeListener)this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.stopListening(n);
            }
        }
    }

    public void propertyChanged(INode node, String id) {
        this.receiveUpdate((IG3DNode)node, id, this.graphModified.contains(node));
    }

    public <T extends INode> void nodeAdded(ParentNode<T> node, INode child, String rel) {
        this.receiveAdd((IG3DNode)child, rel, this.graphModified.contains(node));
    }

    public <T extends INode> void nodeRemoved(ParentNode<T> node, INode child, String rel) {
        this.receiveRemove((IG3DNode)child, rel, this.graphModified.contains(node));
        this.stopListening(child);
    }

    public void delete() {
        this.changeTracking = false;
        this.panel.removeListener(this);
        this.mapping.removeMappingListener((IMappingListener)this);
        ArrayList nodes = new ArrayList(this.nodeToActor.getKeySize());
        nodes.addAll(this.nodeToActor.getKeys());
        for (IG3DNode node : nodes) {
            node.removeListener((NodeListener)this);
            this.removeActor(node);
            node.cleanup();
        }
        for (vtkProp prop : this.actorToNode.keySet()) {
            if (prop.GetVTKId() == 0L) continue;
            prop.Delete();
        }
        this.actorToNode.clear();
        this.nodeToActor.clear();
    }

    public void addListener(NodeListener listener) {
        this.nodeListeners.add(listener);
    }

    public void removeListener(NodeListener listener) {
        this.nodeListeners.remove(listener);
    }

    public IMapping<Object, E> getMapping() {
        return this.mapping;
    }
}

