/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.scenegraph2;

import org.jcae.opencascade.jni.BRepBuilderAPI_MakeEdge;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeFace;
import org.jcae.opencascade.jni.BRepBuilderAPI_MakeWire;
import org.jcae.opencascade.jni.BRepPrimAPI_MakeRevol;
import org.jcae.opencascade.jni.GC_MakeArcOfCircle;
import org.jcae.opencascade.jni.GC_MakeSegment;
import org.jcae.opencascade.jni.Geom_Curve;
import org.jcae.opencascade.jni.TopoDS_Edge;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.jcae.opencascade.jni.TopoDS_Wire;
import org.simantics.g3d.csg.scenegraph2.CSGnode;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.objmap.graph.annotations.GraphType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

@GraphType(value="http://www.simantics.org/CSG-0.1/Barrel")
public class BarrelNode
extends CSGnode {
    private double r1 = 1.0;
    private double r2 = 1.1;
    private double h = 1.0;

    @RelatedSetValue(value="http://www.simantics.org/CSG-0.1/HasMinorRadius")
    @SetPropertyValue(value="http://www.simantics.org/CSG-0.1/HasMinorRadius")
    public void setR1(double r1) {
        this.r1 = r1;
        this.firePropertyChanged("http://www.simantics.org/CSG-0.1/HasMinorRadius");
    }

    @RelatedSetValue(value="http://www.simantics.org/CSG-0.1/HasMajorRadius")
    @SetPropertyValue(value="http://www.simantics.org/CSG-0.1/HasMajorRadius")
    public void setR2(double r2) {
        this.r2 = r2;
        this.firePropertyChanged("http://www.simantics.org/CSG-0.1/HasMajorRadius");
    }

    @RelatedSetValue(value="http://www.simantics.org/CSG-0.1/HasHeight")
    @SetPropertyValue(value="http://www.simantics.org/CSG-0.1/HasHeight")
    public void setH(double h) {
        this.h = h;
        this.firePropertyChanged("http://www.simantics.org/CSG-0.1/HasHeight");
    }

    @RelatedGetValue(value="http://www.simantics.org/CSG-0.1/HasHeight")
    @GetPropertyValue(value="http://www.simantics.org/CSG-0.1/HasHeight", name="Height")
    public double getH() {
        return this.h;
    }

    @RelatedGetValue(value="http://www.simantics.org/CSG-0.1/HasMinorRadius")
    @GetPropertyValue(value="http://www.simantics.org/CSG-0.1/HasMinorRadius", name="Minor Radius")
    public double getR1() {
        return this.r1;
    }

    @RelatedGetValue(value="http://www.simantics.org/CSG-0.1/HasMajorRadius")
    @GetPropertyValue(value="http://www.simantics.org/CSG-0.1/HasMajorRadius", name="Major Radius")
    public double getR2() {
        return this.r2;
    }

    @Override
    public TopoDS_Shape getBaseGeometry() {
        if (Math.abs(this.r1 - this.r2) < 0.001) {
            this.r2 = this.r1 + 0.001;
        }
        double[] p0 = new double[]{0.0, -this.h * 0.5, 0.0};
        double[] p1 = new double[]{0.0, -this.h * 0.5, this.r1};
        double[] p2 = new double[]{0.0, 0.0, this.r2};
        double[] p3 = new double[]{0.0, this.h * 0.5, this.r1};
        double[] p4 = new double[]{0.0, this.h * 0.5, 0.0};
        GC_MakeArcOfCircle m = new GC_MakeArcOfCircle(p1, p2, p3);
        GC_MakeSegment s1 = new GC_MakeSegment(p0, p1);
        GC_MakeSegment s2 = new GC_MakeSegment(p3, p4);
        BRepBuilderAPI_MakeEdge edge = new BRepBuilderAPI_MakeEdge((Geom_Curve)s1.value());
        TopoDS_Edge e1 = (TopoDS_Edge)edge.shape();
        edge.delete();
        edge = new BRepBuilderAPI_MakeEdge((Geom_Curve)m.value());
        TopoDS_Edge e2 = (TopoDS_Edge)edge.shape();
        edge.delete();
        edge = new BRepBuilderAPI_MakeEdge((Geom_Curve)s2.value());
        TopoDS_Edge e3 = (TopoDS_Edge)edge.shape();
        edge.delete();
        BRepBuilderAPI_MakeWire wire = new BRepBuilderAPI_MakeWire(e1, e2, e3);
        TopoDS_Wire w = (TopoDS_Wire)wire.shape();
        wire.delete();
        BRepBuilderAPI_MakeFace face = new BRepBuilderAPI_MakeFace(w);
        TopoDS_Face F = (TopoDS_Face)face.shape();
        face.delete();
        BRepPrimAPI_MakeRevol revol = new BRepPrimAPI_MakeRevol((TopoDS_Shape)F, new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 0.0});
        TopoDS_Shape shape = revol.shape();
        revol.delete();
        m.delete();
        s1.delete();
        s2.delete();
        e1.delete();
        e2.delete();
        e3.delete();
        w.delete();
        F.delete();
        return shape;
    }
}

