/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.simantics.db.Session;
import org.simantics.g3d.csg.scenegraph2.CSGrootNode;
import org.simantics.g3d.csg.scenegraph2.ICSGnode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.vtk.common.AbstractVTKNodeMap;
import org.simantics.g3d.vtk.common.InteractiveVtkPanel;
import org.simantics.objmap.graph.IMapping;
import org.simantics.utils.threads.AWTThread;
import vtk.vtkPanel;
import vtk.vtkProp;
import vtk.vtkProp3D;

public class CSGNodeMap
extends AbstractVTKNodeMap<ICSGnode> {
    public CSGNodeMap(Session session, IMapping mapping, InteractiveVtkPanel panel, CSGrootNode rootNode) {
        super(session, mapping, panel, (ParentNode)rootNode);
        rootNode.setNodeMap(this);
    }

    protected void updateActor(ICSGnode node, Set<String> ids) {
        if (node.getParent() instanceof ICSGnode) {
            ICSGnode parent = (ICSGnode)node.getParent();
            if (!"child".equals(node.getParentRel())) {
                this.updateActor(parent, null);
                return;
            }
        }
        if (node instanceof ParentNode) {
            ParentNode p = (ParentNode)node;
            for (ICSGnode n : p.getNodes()) {
                this.remActor(n);
            }
        }
        this.remActor(node);
        this.addActor(node);
    }

    protected Collection<vtkProp> getActors(ICSGnode node) {
        ArrayList<vtkProp> props = new ArrayList<vtkProp>();
        for (vtkProp3D p : node.getActors()) {
            props.add((vtkProp)p);
        }
        return props;
    }

    protected void removeActor(ICSGnode node) {
        this.remActor(node);
        if (!"child".equals(node.getParentRel()) && node.getParent() instanceof ICSGnode) {
            this.updateActor((ICSGnode)node.getParent(), null);
        }
    }

    protected void addActor(ICSGnode node) {
        if (this.hasActor(node)) {
            return;
        }
        if (Thread.currentThread() != AWTThread.getThreadAccess().getThread()) {
            throw new RuntimeException("Illegal thread.");
        }
        this.panel.lock();
        node.visualize((vtkPanel)this.panel);
        for (vtkProp3D act : node.getActors()) {
            this.nodeToActor.add((Object)node, (Object)act);
            this.actorToNode.put(act, node);
        }
        this.panel.unlock();
    }

    private boolean hasActor(ICSGnode node) {
        List list = this.nodeToActor.getValues((Object)node);
        return list != null && list.size() != 0;
    }

    private void remActor(ICSGnode node) {
        if (Thread.currentThread() != AWTThread.getThreadAccess().getThread()) {
            throw new RuntimeException("Illegal thread.");
        }
        List list = this.nodeToActor.getValues((Object)node);
        if (list != null) {
            for (vtkProp obj : list) {
                this.actorToNode.remove(obj);
            }
            this.nodeToActor.remove((Object)node);
            this.panel.lock();
            node.stopVisualize();
            this.panel.unlock();
        }
    }
}

