/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.actions;

import org.eclipse.jface.action.Action;
import org.simantics.g3d.csg.scenegraph2.CSGnode;
import org.simantics.g3d.csg.scenegraph2.CSGrootNode;
import org.simantics.utils.ui.ExceptionUtils;

public class AddPrimitiveAction2
extends Action {
    CSGrootNode root;
    Class<? extends CSGnode> primitiveClass;

    public AddPrimitiveAction2(CSGrootNode root, Class<? extends CSGnode> primitiveClass) {
        String name = primitiveClass.getSimpleName();
        if (name.endsWith("Node")) {
            name = name.substring(0, name.length() - 4);
        }
        this.setText(name);
        this.primitiveClass = primitiveClass;
        this.root = root;
    }

    public void run() {
        try {
            CSGnode node = this.primitiveClass.newInstance();
            String name = this.root.getUniqueName(node.getClass().getSimpleName());
            node.setName(name);
            this.root.addChild(node);
            this.root.getNodeMap().commit();
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)"Cannot create primitive.", (Throwable)e);
        }
    }
}

