/*
 * Decompiled with CFR 0.152.
 */
package org.jcae.opencascade.jni;

import org.jcae.opencascade.jni.OccJavaJNI;
import org.jcae.opencascade.jni.TopAbs_Orientation;
import org.jcae.opencascade.jni.TopAbs_ShapeEnum;
import org.jcae.opencascade.jni.TopoDS_CompSolid;
import org.jcae.opencascade.jni.TopoDS_Compound;
import org.jcae.opencascade.jni.TopoDS_Edge;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Shell;
import org.jcae.opencascade.jni.TopoDS_Solid;
import org.jcae.opencascade.jni.TopoDS_Vertex;
import org.jcae.opencascade.jni.TopoDS_Wire;

public class TopoDS_Shape {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private long myTShape;

    public TopoDS_Shape(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(TopoDS_Shape obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OccJavaJNI.delete_TopoDS_Shape(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    protected static TopoDS_Shape downcast(TopoDS_Shape in) {
        TopoDS_Shape toReturn = TopoDS_Shape.create(TopoDS_Shape.getCPtr(in));
        in.swigCMemOwn = false;
        return toReturn;
    }

    protected static TopoDS_Shape create(long in) {
        if (in == 0L) {
            return null;
        }
        TopAbs_ShapeEnum type = TopAbs_ShapeEnum.swigToEnum(OccJavaJNI.TopoDS_Shape_shapeType(in, null));
        return TopoDS_Shape.create(in, type);
    }

    protected static TopoDS_Shape create(long in, TopAbs_ShapeEnum type) {
        TopoDS_Shape toReturn = null;
        if (in == 0L) {
            return null;
        }
        switch (type) {
            case COMPOUND: {
                toReturn = new TopoDS_Compound(in, true);
                break;
            }
            case COMPSOLID: {
                toReturn = new TopoDS_CompSolid(in, true);
                break;
            }
            case SOLID: {
                toReturn = new TopoDS_Solid(in, true);
                break;
            }
            case SHELL: {
                toReturn = new TopoDS_Shell(in, true);
                break;
            }
            case FACE: {
                toReturn = new TopoDS_Face(in, true);
                break;
            }
            case WIRE: {
                toReturn = new TopoDS_Wire(in, true);
                break;
            }
            case EDGE: {
                toReturn = new TopoDS_Edge(in, true);
                break;
            }
            case VERTEX: {
                toReturn = new TopoDS_Vertex(in, true);
            }
        }
        toReturn.myTShape = toReturn.getTShape();
        return toReturn;
    }

    public boolean isSame(TopoDS_Shape s) {
        return this.nativeIsSame(s);
    }

    public boolean equals(Object o) {
        if (o instanceof TopoDS_Shape) {
            return this.isSame((TopoDS_Shape)o);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode(Integer.MAX_VALUE);
    }

    protected static TopoDS_Shape[] cArrayWrap(long[] ptrs) {
        TopoDS_Shape[] toReturn = new TopoDS_Shape[ptrs.length / 2];
        int i = 0;
        int j = 0;
        while (i < toReturn.length) {
            long ptr = ptrs[j++];
            int type = (int)ptrs[j++];
            toReturn[i] = TopoDS_Shape.create(ptr, TopAbs_ShapeEnum.swigToEnum(type));
            ++i;
        }
        return toReturn;
    }

    protected static long[] cArrayUnwrap(TopoDS_Shape[] arrayWrapper) {
        long[] cArray = new long[arrayWrapper.length];
        int i = 0;
        while (i < arrayWrapper.length) {
            cArray[i] = TopoDS_Shape.getCPtr(arrayWrapper[i]);
            ++i;
        }
        return cArray;
    }

    public TopAbs_ShapeEnum shapeType() {
        return TopAbs_ShapeEnum.swigToEnum(OccJavaJNI.TopoDS_Shape_shapeType(this.swigCPtr, this));
    }

    public boolean nativeIsSame(TopoDS_Shape other) {
        return OccJavaJNI.TopoDS_Shape_nativeIsSame(this.swigCPtr, this, TopoDS_Shape.getCPtr(other), other);
    }

    public TopAbs_Orientation orientation() {
        return TopAbs_Orientation.swigToEnum(OccJavaJNI.TopoDS_Shape_orientation(this.swigCPtr, this));
    }

    public void reverse() {
        OccJavaJNI.TopoDS_Shape_reverse(this.swigCPtr, this);
    }

    public TopoDS_Shape reversed() {
        long cPtr = OccJavaJNI.TopoDS_Shape_reversed(this.swigCPtr, this);
        return TopoDS_Shape.create(cPtr);
    }

    public int hashCode(int Upper) {
        return OccJavaJNI.TopoDS_Shape_hashCode(this.swigCPtr, this, Upper);
    }

    public boolean free() {
        return OccJavaJNI.TopoDS_Shape_free__SWIG_0(this.swigCPtr, this);
    }

    public void free(boolean F) {
        OccJavaJNI.TopoDS_Shape_free__SWIG_1(this.swigCPtr, this, F);
    }

    public long getTShape() {
        return OccJavaJNI.TopoDS_Shape_getTShape(this.swigCPtr, this);
    }

    public TopoDS_Shape() {
        this(OccJavaJNI.new_TopoDS_Shape(), true);
    }
}

