/*
 * Decompiled with CFR 0.152.
 */
package org.jcae.opencascade.jni;

import org.jcae.opencascade.jni.Geom_Surface;
import org.jcae.opencascade.jni.OccJavaJNI;

public class GeomLProp_SLProps {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public GeomLProp_SLProps(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(GeomLProp_SLProps obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OccJavaJNI.delete_GeomLProp_SLProps(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setParameter(double u, double v) {
        this.setParameters(u, v);
    }

    public double[] normal() {
        double[] toReturn = new double[3];
        this.normal(toReturn);
        return toReturn;
    }

    public double[] normalArray(double[] uvNodes) {
        if (uvNodes == null) {
            throw new NullPointerException();
        }
        if (uvNodes.length % 2 != 0) {
            throw new IllegalArgumentException("uvNodes array length must be peer");
        }
        int numNodes = uvNodes.length / 2;
        double[] toReturn = new double[numNodes * 3];
        this.normalArray(uvNodes, toReturn, numNodes);
        return toReturn;
    }

    public double[] curvatureDirections() {
        double[] toReturn = new double[6];
        if (this.isCurvatureDefined()) {
            double[] max = new double[3];
            double[] min = new double[3];
            this.curvatureDirection(max, min);
            System.arraycopy(max, 0, toReturn, 0, 3);
            System.arraycopy(min, 0, toReturn, 3, 3);
        }
        return toReturn;
    }

    public GeomLProp_SLProps(int degree, double resolution) {
        this(OccJavaJNI.new_GeomLProp_SLProps(degree, resolution), true);
    }

    public void setParameters(double u, double v) {
        OccJavaJNI.GeomLProp_SLProps_setParameters(this.swigCPtr, this, u, v);
    }

    public double[] value() {
        return OccJavaJNI.GeomLProp_SLProps_value(this.swigCPtr, this);
    }

    public double[] d1U() {
        return OccJavaJNI.GeomLProp_SLProps_d1U(this.swigCPtr, this);
    }

    public double[] d1V() {
        return OccJavaJNI.GeomLProp_SLProps_d1V(this.swigCPtr, this);
    }

    public double[] d2U() {
        return OccJavaJNI.GeomLProp_SLProps_d2U(this.swigCPtr, this);
    }

    public double[] d2V() {
        return OccJavaJNI.GeomLProp_SLProps_d2V(this.swigCPtr, this);
    }

    public double[] dUV() {
        return OccJavaJNI.GeomLProp_SLProps_dUV(this.swigCPtr, this);
    }

    public boolean isTangentUDefined() {
        return OccJavaJNI.GeomLProp_SLProps_isTangentUDefined(this.swigCPtr, this);
    }

    public void tangentU(double[] D) {
        OccJavaJNI.GeomLProp_SLProps_tangentU(this.swigCPtr, this, D);
    }

    public boolean isTangentVDefined() {
        return OccJavaJNI.GeomLProp_SLProps_isTangentVDefined(this.swigCPtr, this);
    }

    public void tangentV(double[] D) {
        OccJavaJNI.GeomLProp_SLProps_tangentV(this.swigCPtr, this, D);
    }

    public boolean isNormalDefined() {
        return OccJavaJNI.GeomLProp_SLProps_isNormalDefined(this.swigCPtr, this);
    }

    public boolean isCurvatureDefined() {
        return OccJavaJNI.GeomLProp_SLProps_isCurvatureDefined(this.swigCPtr, this);
    }

    public boolean isUmbilic() {
        return OccJavaJNI.GeomLProp_SLProps_isUmbilic(this.swigCPtr, this);
    }

    public double meanCurvature() {
        return OccJavaJNI.GeomLProp_SLProps_meanCurvature(this.swigCPtr, this);
    }

    public double gaussianCurvature() {
        return OccJavaJNI.GeomLProp_SLProps_gaussianCurvature(this.swigCPtr, this);
    }

    public void setSurface(Geom_Surface S) {
        OccJavaJNI.GeomLProp_SLProps_setSurface(this.swigCPtr, this, Geom_Surface.getCPtr(S), S);
    }

    public void normal(double[] normal) {
        OccJavaJNI.GeomLProp_SLProps_normal(this.swigCPtr, this, normal);
    }

    private void normalArray(double[] uvNodes, double[] normalArray, int numNodes) {
        OccJavaJNI.GeomLProp_SLProps_normalArray(this.swigCPtr, this, uvNodes, normalArray, numNodes);
    }

    public double minCurvature() {
        return OccJavaJNI.GeomLProp_SLProps_minCurvature(this.swigCPtr, this);
    }

    public double maxCurvature() {
        return OccJavaJNI.GeomLProp_SLProps_maxCurvature(this.swigCPtr, this);
    }

    public void curvatureDirection(double[] jmax, double[] jmin) {
        OccJavaJNI.GeomLProp_SLProps_curvatureDirection(this.swigCPtr, this, jmax, jmin);
    }
}

