/*
 * Decompiled with CFR 0.152.
 */
package org.jcae.opencascade.jni;

import org.jcae.opencascade.jni.Geom2d_Curve;
import org.jcae.opencascade.jni.GeomAbs_Shape;
import org.jcae.opencascade.jni.Geom_Curve;
import org.jcae.opencascade.jni.Geom_Surface;
import org.jcae.opencascade.jni.OccJavaJNI;
import org.jcae.opencascade.jni.Poly_Triangulation;
import org.jcae.opencascade.jni.TopLoc_Location;
import org.jcae.opencascade.jni.TopoDS_Edge;
import org.jcae.opencascade.jni.TopoDS_Face;
import org.jcae.opencascade.jni.TopoDS_Vertex;

public class BRep_Tool {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public BRep_Tool(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(BRep_Tool obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OccJavaJNI.delete_BRep_Tool(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static double[] range(TopoDS_Edge edge) {
        double[] toReturn = new double[2];
        BRep_Tool.range(edge, toReturn);
        return toReturn;
    }

    public static Geom2d_Curve curveOnSurface(TopoDS_Edge e, TopoDS_Face f, double[] range) {
        double[] d2 = new double[1];
        Geom2d_Curve toReturn = BRep_Tool.curveOnSurface(e, f, range, d2);
        range[1] = d2[0];
        return toReturn;
    }

    public static Geom_Curve curve(TopoDS_Edge e, double[] range) {
        double[] d2 = new double[1];
        Geom_Curve toReturn = BRep_Tool.curve(e, range, d2);
        range[1] = d2[0];
        return toReturn;
    }

    public static double[] pnt(TopoDS_Vertex V) {
        return OccJavaJNI.BRep_Tool_pnt(TopoDS_Vertex.getCPtr(V), V);
    }

    public static double[] parameters(TopoDS_Vertex V, TopoDS_Face F) {
        return OccJavaJNI.BRep_Tool_parameters(TopoDS_Vertex.getCPtr(V), V, TopoDS_Face.getCPtr(F), F);
    }

    public static double parameter(TopoDS_Vertex V, TopoDS_Edge E) {
        return OccJavaJNI.BRep_Tool_parameter(TopoDS_Vertex.getCPtr(V), V, TopoDS_Edge.getCPtr(E), E);
    }

    public static boolean degenerated(TopoDS_Edge E) {
        return OccJavaJNI.BRep_Tool_degenerated(TopoDS_Edge.getCPtr(E), E);
    }

    public static boolean hasContinuity(TopoDS_Edge E, TopoDS_Face F1, TopoDS_Face F2) {
        return OccJavaJNI.BRep_Tool_hasContinuity(TopoDS_Edge.getCPtr(E), E, TopoDS_Face.getCPtr(F1), F1, TopoDS_Face.getCPtr(F2), F2);
    }

    public static GeomAbs_Shape continuity(TopoDS_Edge E, TopoDS_Face F1, TopoDS_Face F2) {
        return GeomAbs_Shape.swigToEnum(OccJavaJNI.BRep_Tool_continuity(TopoDS_Edge.getCPtr(E), E, TopoDS_Face.getCPtr(F1), F1, TopoDS_Face.getCPtr(F2), F2));
    }

    public static double tolerance(TopoDS_Face F) {
        return OccJavaJNI.BRep_Tool_tolerance__SWIG_0(TopoDS_Face.getCPtr(F), F);
    }

    public static double tolerance(TopoDS_Edge E) {
        return OccJavaJNI.BRep_Tool_tolerance__SWIG_1(TopoDS_Edge.getCPtr(E), E);
    }

    public static double tolerance(TopoDS_Vertex V) {
        return OccJavaJNI.BRep_Tool_tolerance__SWIG_2(TopoDS_Vertex.getCPtr(V), V);
    }

    public static Poly_Triangulation triangulation(TopoDS_Face F, TopLoc_Location L) {
        long cPtr = OccJavaJNI.BRep_Tool_triangulation(TopoDS_Face.getCPtr(F), F, TopLoc_Location.getCPtr(L), L);
        return cPtr == 0L ? null : new Poly_Triangulation(cPtr, false);
    }

    public static void range(TopoDS_Edge E, double[] range) {
        OccJavaJNI.BRep_Tool_range(TopoDS_Edge.getCPtr(E), E, range);
    }

    public static Geom_Curve curve(TopoDS_Edge E, double[] First, double[] Last) {
        long cPtr = OccJavaJNI.BRep_Tool_curve(TopoDS_Edge.getCPtr(E), E, First, Last);
        return cPtr == 0L ? null : new Geom_Curve(cPtr, false);
    }

    public static Geom_Surface surface(TopoDS_Face F) {
        long cPtr = OccJavaJNI.BRep_Tool_surface(TopoDS_Face.getCPtr(F), F);
        return cPtr == 0L ? null : new Geom_Surface(cPtr, false);
    }

    public static Geom2d_Curve curveOnSurface(TopoDS_Edge E, TopoDS_Face F, double[] First, double[] Last) {
        long cPtr = OccJavaJNI.BRep_Tool_curveOnSurface(TopoDS_Edge.getCPtr(E), E, TopoDS_Face.getCPtr(F), F, First, Last);
        return cPtr == 0L ? null : new Geom2d_Curve(cPtr, false);
    }

    public BRep_Tool() {
        this(OccJavaJNI.new_BRep_Tool(), true);
    }
}

