/*
 * Decompiled with CFR 0.152.
 */
package org.jcae.opencascade.jni;

import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jcae.opencascade.jni.BRep_Builder;
import org.jcae.opencascade.jni.OccJavaJNI;
import org.jcae.opencascade.jni.TopoDS_Shape;

public class BRepTools {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public BRepTools(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(BRepTools obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    private synchronized void delete() {
    }

    public static TopoDS_Shape read(String file, BRep_Builder builder) {
        TopoDS_Shape toReturn = new TopoDS_Shape();
        if (BRepTools.read(toReturn, file, builder)) {
            return TopoDS_Shape.downcast(toReturn);
        }
        return null;
    }

    public static boolean read(TopoDS_Shape shape, String file, BRep_Builder builder) {
        return OccJavaJNI.BRepTools_read__SWIG_0(TopoDS_Shape.getCPtr(shape), shape, file, BRep_Builder.getCPtr(builder), builder);
    }

    public static boolean write(TopoDS_Shape shape, String file) {
        return OccJavaJNI.BRepTools_write__SWIG_0(TopoDS_Shape.getCPtr(shape), shape, file);
    }

    public static void write(TopoDS_Shape Sh, WritableByteChannel S) {
        OccJavaJNI.BRepTools_write__SWIG_1(TopoDS_Shape.getCPtr(Sh), Sh, S);
    }

    public static void clean(TopoDS_Shape S) {
        OccJavaJNI.BRepTools_clean(TopoDS_Shape.getCPtr(S), S);
    }

    public static boolean read(TopoDS_Shape shape, ReadableByteChannel input, BRep_Builder builder) {
        return OccJavaJNI.BRepTools_read__SWIG_1(TopoDS_Shape.getCPtr(shape), shape, input, BRep_Builder.getCPtr(builder), builder);
    }
}

