/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.fmi.studio.core.FMIExperimentDB;
import org.simantics.fmi.studio.core.FMIExperimentDataFrameDatasource;
import org.simantics.fmil.core.FMILException;
import org.simantics.simulation.data.AbstractDatasource;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.VariableHandle;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIDatasource
extends AbstractDatasource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIDatasource.class);
    private Semaphore frameSet = new Semaphore(5);
    private ExecutorService exec = Executors.newFixedThreadPool(1);
    private FMIExperimentDB experiment;

    public FMIDatasource(FMIExperimentDB experiment) {
        this.experiment = experiment;
    }

    public void dispose() {
        if (this.exec != null) {
            this.exec.shutdown();
            this.exec = null;
        }
        this.experiment = null;
    }

    public Collection<String> getVariables() {
        return this.experiment.getVariables();
    }

    public Datatype getType(String key) {
        return Datatypes.DOUBLE;
    }

    public VariableHandle openHandle(Bean item, String key_, Binding valueBinding) {
        try {
            String key = key_.substring(1, key_.length() - 6).replace('/', '.');
            this.experiment.subscribe(key);
            return new FMIVariableHandle(key, valueBinding);
        }
        catch (FMILException e) {
            LOGGER.error("Error while opening data source handle", (Throwable)e);
            return null;
        }
    }

    public Object getTime(NumberBinding binding) {
        try {
            return binding.create((Number)this.experiment.getSimulationTime());
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyStep() {
        FMIExperimentDataFrameDatasource ds = new FMIExperimentDataFrameDatasource(this, this.experiment.getCurrentDataFrame());
        try {
            if (!this.frameSet.tryAcquire()) {
                long start = System.nanoTime();
                this.frameSet.acquire();
                long duration = System.nanoTime() - start;
                System.err.println("Blocked for " + 1.0E-6 * (double)duration + "ms for FMI data frame processing");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Error while queuing FMI data frame", (Throwable)e);
        }
        this.exec.submit(() -> {
            FMIDatasource.super.notifyStep(ds);
            this.frameSet.release();
        });
    }

    public class FMIVariableHandle
    implements VariableHandle {
        String key;
        Binding binding;

        public FMIVariableHandle(String key, Binding binding) {
            this.key = key;
            this.binding = binding;
        }

        public String key() {
            return this.key;
        }

        public Binding binding() {
            return this.binding;
        }

        public Object getValue() throws AccessorException {
            try {
                return FMIDatasource.this.experiment.getEngineValueById(this.key);
            }
            catch (NodeManagerException e) {
                throw new AccessorException((Throwable)e);
            }
        }

        public Object getValue(Datasource datasource) throws AccessorException {
            FMIExperimentDataFrameDatasource ds = (FMIExperimentDataFrameDatasource)datasource;
            return ds.getValue(this.key);
        }

        public void dispose() {
        }
    }
}

