/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.rpcexperiment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.simantics.fmi.rpcexperiment.Activator;

public abstract class JavaProcess {
    private Process process;
    private StringBuilder stdout = new StringBuilder();
    private StringBuilder errout = new StringBuilder();

    protected abstract Process startProcess() throws IOException;

    public int exec() throws IOException, InterruptedException {
        this.process = this.startProcess();
        this.readOutput(this.process.getInputStream(), true);
        this.readOutput(this.process.getErrorStream(), false);
        this.process.waitFor();
        return this.process.exitValue();
    }

    public void execAsync() throws IOException {
        this.process = this.startProcess();
        this.readOutput(this.process.getInputStream(), true);
        this.readOutput(this.process.getErrorStream(), false);
    }

    public Process getProcess() {
        return this.process;
    }

    protected void readOutput(final InputStream input, final boolean std) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = std ? JavaProcess.this.stdout : JavaProcess.this.errout;
                try {
                    int data;
                    while ((data = input.read()) != -1) {
                        sb.append((char)data);
                        System.err.print((char)data);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    public String getStdout() {
        return this.stdout.toString();
    }

    public String getErrout() {
        return this.errout.toString();
    }

    public void dispose() {
        if (this.process != null) {
            if (this.process.isAlive()) {
                this.process.destroy();
            }
            this.process = null;
        }
    }

    protected String resolveJavaHome() {
        String javaHome = null;
        Map<String, String> env = System.getenv();
        Properties prop = System.getProperties();
        if (env.containsKey("JAVA_HOME")) {
            javaHome = env.get("JAVA_HOME");
        } else if (env.containsKey("Path")) {
            String[] paths;
            String path = env.get("Path");
            String[] stringArray = paths = path.split(";");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                int i = p.indexOf("Java");
                if (i > 0) {
                    int j = p.indexOf("/", i + 5);
                    if (j > 0) {
                        javaHome = p.substring(0, j);
                        break;
                    }
                    j = p.indexOf("\\", i + 5);
                    if (j > 0) {
                        javaHome = p.substring(0, j);
                        break;
                    }
                }
                ++n2;
            }
        }
        return javaHome;
    }

    protected Bundle getBundle(String name) {
        Bundle[] bundleArray = Activator.getContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (name.equals(b.getSymbolicName())) {
                return b;
            }
            ++n2;
        }
        return null;
    }

    protected String injectClassPath(String classpath, Bundle bundle) {
        if (bundle == null) {
            return classpath;
        }
        String loc = bundle.getLocation();
        if (loc == null) {
            return classpath;
        }
        if (loc.startsWith("reference:file:/")) {
            String path = loc.substring("reference:file:/".length());
            if (!path.endsWith("jar")) {
                path = String.valueOf(path) + "bin/";
            }
            classpath = String.valueOf(classpath) + ";" + path;
        }
        return classpath;
    }

    protected String injectClassPath(String classpath, Bundle bundle, String[] libs) {
        if (bundle == null) {
            return classpath;
        }
        String loc = bundle.getLocation();
        if (loc == null) {
            return classpath;
        }
        if (loc.startsWith("reference:file:/")) {
            String path = loc.substring("reference:file:/".length());
            String[] stringArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                classpath = String.valueOf(classpath) + ";" + path + lib;
                ++n2;
            }
        }
        return classpath;
    }

    protected void addParam(List<String> commands, String name, String value) {
        if (name.startsWith("-")) {
            commands.add(name);
        } else {
            commands.add("-" + name);
        }
        commands.add(value);
    }
}

