/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.rpcexperiment.db;

import java.io.File;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.fmi.experiment.FMINodeBase;
import org.simantics.fmi.experiment.FMIRealm;
import org.simantics.fmi.experiment.IFMIExperiment;
import org.simantics.fmi.rpcexperiment.FMIRPCExperiment;
import org.simantics.fmi.studio.core.FMIExperimentDB;
import org.simantics.fmi.studio.core.IFMISessionManager;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.toolkit.db.StandardSessionManager;

public class FMISessionManager
extends StandardSessionManager<FMINodeBase, IFMIExperiment>
implements IFMISessionManager {
    private static FMISessionManager INSTANCE;

    public static FMISessionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FMISessionManager();
        }
        return INSTANCE;
    }

    private FMISessionManager() {
    }

    protected IFMIExperiment createEngine(ReadGraph graph, String id) throws DatabaseException {
        try {
            return new FMIExperimentDB(graph, id){

                protected IFMIExperiment createExperiment(File workingDirectory, File fmuFile, String id) throws Exception {
                    return new FMIRPCExperiment(workingDirectory, fmuFile, id);
                }
            };
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected StandardRealm<FMINodeBase, IFMIExperiment> createRealm(IFMIExperiment engine, String id) {
        return new FMIRealm(engine, id);
    }

    public FMIRealm fmiRealmById(ReadGraph graph, String id) throws DatabaseException {
        return (FMIRealm)FMISessionManager.getInstance().getOrCreateRealm(graph, id);
    }
}

