/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.experiment;

import java.io.File;
import java.nio.file.Paths;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.fmi.experiment.FMIExperiment;
import org.simantics.fmi.experiment.FMUSequenceLoader;
import org.simantics.fmi.experiment.IFMIExperiment;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.simulator.IDynamicExperimentLocal;
import org.simantics.simulator.toolkit.DynamicExperimentActionContext;
import org.simantics.simulator.toolkit.DynamicExperimentThreadListener;

public class FMISequenceRunner {
    public static DynamicExperimentActionContext runAction(Function action, boolean simulateAndWaitCompletion) throws Exception {
        File workDir = new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
        System.out.println("Workdir: " + workDir.toString());
        File file = new File(String.valueOf(workDir.getAbsolutePath()) + "/" + FMUSequenceLoader.getFMUPath());
        System.out.println("FMU File: " + file.toString());
        FMIExperiment experiment = new FMIExperiment(workDir, file, UUID.randomUUID().toString());
        return FMISequenceRunner.runAction(experiment, action, simulateAndWaitCompletion, true);
    }

    public static DynamicExperimentActionContext runActionFromFile(File file, String id, Function action, boolean simulateAndWaitCompletion) throws Exception {
        File workDir = new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
        FMIExperiment experiment = new FMIExperiment(workDir, file, id);
        return FMISequenceRunner.runAction(experiment, action, simulateAndWaitCompletion, true);
    }

    public static DynamicExperimentActionContext runAction(IFMIExperiment experiment, Function action, boolean simulateAndWaitCompletion) {
        return FMISequenceRunner.runAction(experiment, action, simulateAndWaitCompletion, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicExperimentActionContext runAction(final IFMIExperiment experiment, Function action, final boolean simulateAndWaitCompletion, final boolean shutdownExperiment) {
        final DynamicExperimentActionContext context = new DynamicExperimentActionContext((IDynamicExperimentLocal)experiment);
        context.scheduleNextStep((Function1)action);
        final Object sync = new Object();
        final SCLContext sclContext = SCLContext.getCurrent();
        experiment.addListener(new DynamicExperimentThreadListener(){

            public void beforeStep() {
                if (!context.isStopped()) {
                    SCLContext.push((SCLContext)sclContext);
                    context.handleStep(experiment.getSimulationTime());
                    SCLContext.pop();
                }
                this.removeIfStopped();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeIfStopped() {
                if (context.isStopped() && shutdownExperiment) {
                    experiment.removeListener(this);
                    if (simulateAndWaitCompletion) {
                        experiment.simulate(false);
                        Object object = sync;
                        synchronized (object) {
                            sync.notify();
                        }
                    }
                    experiment.shutdown((IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
        if (simulateAndWaitCompletion) {
            experiment.simulate(true);
            try {
                Object object = sync;
                synchronized (object) {
                    while (!context.isStopped()) {
                        sync.wait(1000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                context.stop();
            }
            if (context.exceptions != null && !context.exceptions.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Action failures:");
                for (Exception e : context.exceptions) {
                    builder.append("\n");
                    builder.append(e.getMessage());
                }
                throw new RuntimeException(builder.toString());
            }
        }
        return context;
    }
}

