/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Range;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.RangeType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Ranges
extends SimpleProcProvider {
    public Ranges() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "range_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Range.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Range;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            RangeType rangeType = (RangeType)type;
            Type baseType = rangeType.getBase();
            Range range = (Range)val;
            if (range.isLowerBoundInclusive()) {
                buffer.append('[');
            } else {
                buffer.append('(');
            }
            if (range.hasLowerBound()) {
                StringBuilder lowerBuffer = new StringBuilder();
                baseType.getTextCodec().getEncoder().encode(baseType, lowerBuffer, range.getLowerBound(), context);
                String lower = lowerBuffer.toString();
                if (TxtEncoder.needsQuotes(lower)) {
                    buffer.append('\"').append(lower).append('\"');
                } else {
                    buffer.append(lower);
                }
            }
            buffer.append(',');
            if (range.hasUpperBound()) {
                StringBuilder upperBuffer = new StringBuilder();
                baseType.getTextCodec().getEncoder().encode(baseType, upperBuffer, range.getUpperBound(), context);
                String upper = upperBuffer.toString();
                if (TxtEncoder.needsQuotes(upper)) {
                    buffer.append('\"').append(upper).append('\"');
                } else {
                    buffer.append(upper);
                }
            }
            if (range.isUpperBoundInclusive()) {
                buffer.append(']');
            } else {
                buffer.append(')');
            }
        }

        private static boolean needsQuotes(String elemStr) {
            if (elemStr.isEmpty()) {
                return true;
            }
            if (elemStr.equalsIgnoreCase("NULL")) {
                return true;
            }
            for (int c = 0; c < elemStr.length(); ++c) {
                char ch = elemStr.charAt(c);
                if (ch != '\"' && ch != '\\' && ch != '{' && ch != '}' && ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') continue;
                return true;
            }
            return false;
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Range;
        }

        @Override
        public Class<?> getOutputType() {
            return Range.class;
        }

        @Override
        public Range<?> decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            CharSequence upperTxt;
            CharSequence lowerTxt;
            RangeType rangeType = (RangeType)type;
            Type baseType = rangeType.getBase();
            boolean lowerInc = false;
            boolean upperInc = false;
            Object lower = null;
            Object upper = null;
            if (buffer.charAt(0) == '[') {
                lowerInc = true;
            }
            if (buffer.charAt(buffer.length() - 1) == ']') {
                upperInc = true;
            }
            if ((lowerTxt = buffer.subSequence(1, TxtDecoder.findBound(buffer, 1))).length() != 0) {
                lower = baseType.getTextCodec().getDecoder().decode(baseType, null, null, lowerTxt, context);
            }
            if ((upperTxt = buffer.subSequence(2 + lowerTxt.length(), buffer.length() - 1)).length() != 0) {
                upper = baseType.getTextCodec().getDecoder().decode(baseType, null, null, upperTxt, context);
            }
            return Range.create(lower, lowerInc, upper, upperInc);
        }

        private static int findBound(CharSequence buffer, int start) {
            int stop;
            boolean string = false;
            block4: for (stop = start; stop < buffer.length(); ++stop) {
                char ch = buffer.charAt(stop);
                switch (ch) {
                    case '\"': {
                        string = !string;
                        continue block4;
                    }
                    case '\\': {
                        ++stop;
                        continue block4;
                    }
                    default: {
                        if (ch != ',' || string) continue block4;
                        return stop;
                    }
                }
            }
            return stop;
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Range.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Range;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            buffer.writeInt(-1);
            if (val != null) {
                int writeStart = buffer.writerIndex();
                RangeType rangeType = (RangeType)type;
                Type baseType = rangeType.getBase();
                Range range = (Range)val;
                buffer.writeByte((int)range.getFlags().getValue());
                if (range.getFlags().hasLowerBound()) {
                    baseType.getBinaryCodec().getEncoder().encode(baseType, buffer, range.getLowerBound(), context);
                }
                if (range.getFlags().hasUpperBound()) {
                    baseType.getBinaryCodec().getEncoder().encode(baseType, buffer, range.getUpperBound(), context);
                }
                buffer.setInt(writeStart - 4, buffer.writerIndex() - writeStart);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Range;
        }

        @Override
        public Class<?> getOutputType() {
            return Range.class;
        }

        @Override
        public Range<?> decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            RangeType rangeType = (RangeType)type;
            Type baseType = rangeType.getBase();
            Range instance = null;
            int length = buffer.readInt();
            if (length != -1) {
                Range.Flags flags = new Range.Flags(buffer.readByte());
                Object[] values = new Object[2];
                if (flags.hasLowerBound()) {
                    values[0] = baseType.getBinaryCodec().getDecoder().decode(baseType, null, null, buffer, context);
                }
                if (flags.hasUpperBound()) {
                    values[1] = baseType.getBinaryCodec().getDecoder().decode(baseType, null, null, buffer, context);
                }
                instance = new Range(flags, values);
            }
            return instance;
        }
    }
}

