/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.Protocol;
import com.impossibl.postgres.protocol.ProtocolFactory;
import com.impossibl.postgres.protocol.SSLRequestCommand;
import com.impossibl.postgres.protocol.StartupCommand;
import com.impossibl.postgres.protocol.ssl.SSLEngineFactory;
import com.impossibl.postgres.protocol.ssl.SSLMode;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.protocol.v30.ProtocolShared;
import com.impossibl.postgres.system.BasicContext;
import com.impossibl.postgres.system.NoticeException;
import com.impossibl.postgres.system.Settings;
import com.impossibl.postgres.utils.Converter;
import com.impossibl.postgres.utils.StringTransforms;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class ProtocolFactoryImpl
implements ProtocolFactory {
    @Override
    public Protocol connect(SocketAddress address, BasicContext context) throws IOException, NoticeException {
        SSLMode sslMode = (SSLMode)((Object)context.getSetting("sslMode", new Converter<SSLMode>(){

            @Override
            public SSLMode apply(Object val) {
                if (val == null) {
                    return Settings.SSL_MODE_DEFAULT;
                }
                String valStr = StringTransforms.capitalizeOption(val.toString());
                return SSLMode.valueOf(valStr);
            }
        }));
        return this.connect(sslMode, address, context);
    }

    Protocol connect(SSLMode sslMode, SocketAddress address, BasicContext context) throws IOException, NoticeException {
        try {
            ProtocolShared.Ref sharedRef = ProtocolShared.acquire(context);
            Bootstrap clientBootstrap = sharedRef.get().getBootstrap();
            ChannelFuture connectFuture = clientBootstrap.connect(address).syncUninterruptibly();
            Channel channel = connectFuture.channel();
            ProtocolImpl protocol = ProtocolImpl.newInstance(sharedRef, channel, context);
            if (sslMode != SSLMode.Disable && sslMode != SSLMode.Allow) {
                SSLRequestCommand sslRequestCommand = protocol.createSSLRequest();
                if (sslRequestCommand == null && sslMode.isRequired()) {
                    throw new IOException("SSL not available");
                }
                protocol.execute(sslRequestCommand);
                if (sslRequestCommand.isAllowed()) {
                    SSLEngine sslEngine = SSLEngineFactory.create(sslMode, context);
                    SslHandler sslHandler = new SslHandler(sslEngine);
                    channel.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
                    try {
                        sslHandler.handshakeFuture().syncUninterruptibly();
                    }
                    catch (Exception e) {
                        if (sslMode == SSLMode.Prefer) {
                            return this.connect(SSLMode.Disable, address, context);
                        }
                        throw e;
                    }
                } else if (sslMode.isRequired()) {
                    throw new IOException("SSL not allowed by server");
                }
            }
            try {
                SslHandler sslHandler;
                ProtocolFactoryImpl.startup(protocol, context);
                if (sslMode == SSLMode.VerifyFull && (sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class)) != null) {
                    String hostname = address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostString() : "";
                    this.verifyHostname(hostname, sslHandler.engine().getSession());
                }
            }
            catch (Exception e) {
                switch (sslMode) {
                    case Allow: {
                        return this.connect(SSLMode.Require, address, context);
                    }
                    case Prefer: {
                        return this.connect(SSLMode.Disable, address, context);
                    }
                }
                throw e;
            }
            return protocol;
        }
        catch (NoticeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ProtocolFactoryImpl.translateConnectionException(e);
        }
    }

    private static void startup(ProtocolImpl protocol, BasicContext context) throws IOException, NoticeException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("application_name", context.getSetting("application_name", "pgjdbc app"));
        params.put("client_encoding", context.getSetting("client_encoding", "UTF8"));
        params.put("database", context.getSetting("database", ""));
        params.put("user", context.getSetting("user", ""));
        StartupCommand startup = protocol.createStartup(params);
        protocol.execute(startup);
        Notice error = startup.getError();
        if (error != null) {
            throw new NoticeException("Startup Failed", error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyHostname(String hostname, SSLSession session) throws SSLPeerUnverifiedException {
        LdapName DN;
        X509Certificate[] peerCerts = (X509Certificate[])session.getPeerCertificates();
        if (peerCerts == null || peerCerts.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
        X509Certificate serverCert = peerCerts[0];
        try {
            DN = new LdapName(serverCert.getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException e) {
            throw new SSLPeerUnverifiedException("Invalid name in certificate");
        }
        String CN = null;
        for (Rdn rdn : DN.getRdns()) {
            if (!"CN".equals(rdn.getType())) continue;
            CN = (String)rdn.getValue();
            break;
        }
        if (CN == null) {
            throw new SSLPeerUnverifiedException("Common name not found");
        }
        if (CN.startsWith("*")) {
            if (!hostname.endsWith(CN.substring(1))) throw new SSLPeerUnverifiedException("The hostname " + hostname + " could not be verified");
            if (hostname.substring(0, hostname.length() - CN.length() + 1).contains(".")) return;
            throw new SSLPeerUnverifiedException("The hostname " + hostname + " could not be verified");
        }
        if (CN.equals(hostname)) return;
        throw new SSLPeerUnverifiedException("The hostname " + hostname + " could not be verified");
    }

    private static IOException translateConnectionException(Exception e) {
        IOException io = e instanceof IOException ? (IOException)e : (e.getCause() == null ? new IOException(e) : (e.getCause() instanceof IOException ? (IOException)e.getCause() : new IOException(e.getCause())));
        while (io instanceof SSLHandshakeException) {
            if (io.getCause() instanceof IOException) {
                io = (IOException)io.getCause();
                continue;
            }
            io = new SSLException(io.getCause().getMessage(), io.getCause());
        }
        if (io instanceof SSLException && !io.getMessage().startsWith("SSL Error")) {
            io = new SSLException("SSL Error: " + io.getMessage(), io.getCause());
        }
        return io;
    }
}

