/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.v30.ResponseMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class MessageDecoder
extends ByteToMessageDecoder {
    private State state = State.HEADER;
    private byte id;
    private int length;

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        switch (this.state) {
            case HEADER: {
                if (buffer.readableBytes() < 5) {
                    return;
                }
                this.id = buffer.readByte();
                this.length = buffer.readInt() - 4;
                this.state = State.BODY;
            }
            case BODY: {
                if (buffer.readableBytes() < this.length) {
                    return;
                }
                ByteBuf dataBuffer = buffer.readBytes(this.length);
                out.add(new ResponseMessage(this.id, dataBuffer));
                this.state = State.HEADER;
            }
        }
    }

    private static enum State {
        HEADER,
        BODY;

    }
}

