/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc.xa;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGPooledConnection;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.xa.PGXAConnectionDelegator;
import com.impossibl.postgres.jdbc.xa.PGXAException;
import com.impossibl.postgres.jdbc.xa.RecoveredXid;
import com.impossibl.postgres.protocol.TransactionStatus;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class PGXAConnection
extends PGPooledConnection
implements XAConnection,
XAResource {
    private static final String ERROR_ROLLING_BACK_PREPARED_TRANSACTION = "Error rolling back prepared transaction";
    private static final String TRANSACTION_INTERLEAVING_NOT_IMPLEMENTED = "Transaction interleaving not implemented";
    private static final String XID_MUST_NOT_BE_NULL = "xid must not be null";
    private static final Logger logger = Logger.getLogger(PGXAConnection.class.getName());
    private final PGConnectionImpl conn;
    private Xid currentXid;
    private String xidStr;
    private int state;
    static final int STATE_IDLE = 0;
    static final int STATE_ACTIVE = 1;
    static final int STATE_ENDED = 2;
    private boolean localAutoCommitMode = true;

    private void debug(String s) {
        logger.log(Level.FINE, "XAResource " + Integer.toHexString(this.hashCode()) + ": " + s);
    }

    public PGXAConnection(PGConnectionImpl conn) throws SQLException {
        super(conn, true, true);
        this.conn = conn;
        this.state = 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (logger.isLoggable(Level.FINE)) {
            this.debug("PGXAConnection.getConnection called");
        }
        PGConnection c = (PGConnection)super.getConnection();
        if (this.state == 0) {
            this.conn.setAutoCommit(true);
        }
        return new PGXAConnectionDelegator(this, c);
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            this.debug("starting transaction xid = " + xid);
        }
        if (flags != 0 && flags != 0x8000000 && flags != 0x200000) {
            throw new PGXAException("Invalid flags", -5);
        }
        if (xid == null) {
            throw new PGXAException(XID_MUST_NOT_BE_NULL, -5);
        }
        if (this.state == 1) {
            throw new PGXAException("Connection is busy with another transaction", -6);
        }
        if (flags == 0x8000000) {
            throw new PGXAException("suspend/resume not implemented", -3);
        }
        if (flags == 0x200000) {
            if (this.state != 2) {
                throw new PGXAException(TRANSACTION_INTERLEAVING_NOT_IMPLEMENTED, -3);
            }
            if (!xid.equals(this.currentXid)) {
                throw new PGXAException(TRANSACTION_INTERLEAVING_NOT_IMPLEMENTED, -3);
            }
        } else if (this.state == 2) {
            throw new PGXAException(TRANSACTION_INTERLEAVING_NOT_IMPLEMENTED, -3);
        }
        if (flags == 0) {
            try {
                this.localAutoCommitMode = this.conn.getAutoCommit();
                this.conn.setAutoCommit(false);
            }
            catch (SQLException ex) {
                throw new PGXAException("Error disabling autocommit", ex, -3);
            }
        }
        this.state = 1;
        this.currentXid = xid;
        this.xidStr = null;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            this.debug("ending transaction xid = " + xid);
        }
        if (flags != 0x2000000 && flags != 0x20000000 && flags != 0x4000000) {
            throw new PGXAException("Invalid flags", -5);
        }
        if (xid == null) {
            throw new PGXAException(XID_MUST_NOT_BE_NULL, -5);
        }
        if (this.state != 1 || !this.currentXid.equals(xid)) {
            throw new PGXAException("tried to call end without corresponding start call", -6);
        }
        if (flags == 0x2000000) {
            throw new PGXAException("suspend/resume not implemented", -3);
        }
        this.state = 2;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            this.debug("preparing transaction xid = " + xid);
        }
        if (this.currentXid == null) {
            throw new PGXAException("Not associated with an xid", -3);
        }
        if (!this.currentXid.equals(xid)) {
            throw new PGXAException("Not implemented: Prepare must be issued using the same connection that started the transaction", -3);
        }
        if (this.state != 2) {
            throw new PGXAException("Prepare called before end", -5);
        }
        this.state = 0;
        this.currentXid = null;
        try {
            this.xidStr = RecoveredXid.xidToString(xid);
            try (PGStatement stmt = this.conn.createStatement();){
                stmt.executeUpdate("PREPARE TRANSACTION '" + this.xidStr + "'");
            }
            this.conn.setAutoCommit(this.localAutoCommitMode);
            return 0;
        }
        catch (SQLTimeoutException ste) {
            throw new PGXAException("Error preparing transaction", ste, -7);
        }
        catch (SQLException ex) {
            throw new PGXAException("Error preparing transaction", ex, -3);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Xid[] recover(int flag) throws XAException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        block10: {
            if (logger.isLoggable(Level.FINE)) {
                this.debug("rolling back xid = " + xid);
            }
            if (xid == null) {
                throw new PGXAException(XID_MUST_NOT_BE_NULL, -5);
            }
            try {
                if (this.currentXid != null && xid.equals(this.currentXid)) {
                    this.state = 0;
                    this.currentXid = null;
                    this.xidStr = null;
                    this.conn.rollback();
                    this.conn.setAutoCommit(this.localAutoCommitMode);
                    break block10;
                }
                String s = this.xidStr != null ? this.xidStr : RecoveredXid.xidToString(xid);
                this.conn.setAutoCommit(true);
                PGStatement stmt = this.conn.createStatement();
                try {
                    stmt.executeUpdate("ROLLBACK PREPARED '" + s + "'");
                }
                finally {
                    this.xidStr = null;
                    stmt.close();
                }
            }
            catch (SQLTimeoutException ste) {
                throw new PGXAException(ERROR_ROLLING_BACK_PREPARED_TRANSACTION, ste, -7);
            }
            catch (SQLException ex) {
                if ("42704".equals(ex.getSQLState())) {
                    throw new PGXAException(ERROR_ROLLING_BACK_PREPARED_TRANSACTION, ex, -4);
                }
                throw new PGXAException(ERROR_ROLLING_BACK_PREPARED_TRANSACTION, ex, -3);
            }
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            this.debug("committing xid = " + xid + (onePhase ? " (one phase) " : " (two phase)"));
        }
        if (xid == null) {
            throw new PGXAException(XID_MUST_NOT_BE_NULL, -5);
        }
        if (onePhase) {
            this.commitOnePhase(xid);
        } else {
            this.commitPrepared(xid);
        }
    }

    private void commitOnePhase(Xid xid) throws XAException {
        try {
            if (this.currentXid == null || !this.currentXid.equals(xid)) {
                throw new PGXAException("Not implemented: one-phase commit must be issued using the same connection that was used to start it", -3);
            }
            if (this.state != 2) {
                throw new PGXAException("commit called before end", -6);
            }
            this.state = 0;
            this.currentXid = null;
            this.xidStr = null;
            this.conn.commit();
            this.conn.setAutoCommit(this.localAutoCommitMode);
        }
        catch (SQLTimeoutException ste) {
            throw new PGXAException("Error during one-phase commit", ste, -7);
        }
        catch (SQLException ex) {
            throw new PGXAException("Error during one-phase commit", ex, -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPrepared(Xid xid) throws XAException {
        try {
            if (this.state != 0 || this.conn.getProtocol().getTransactionStatus() != TransactionStatus.Idle) {
                throw new PGXAException("Not implemented: 2nd phase commit must be issued using an idle connection", -3);
            }
            String s = this.xidStr != null ? this.xidStr : RecoveredXid.xidToString(xid);
            this.localAutoCommitMode = this.conn.getAutoCommit();
            this.conn.setAutoCommit(true);
            PGStatement stmt = this.conn.createStatement();
            try {
                stmt.executeUpdate("COMMIT PREPARED '" + s + "'");
            }
            finally {
                this.xidStr = null;
                stmt.close();
                this.conn.setAutoCommit(this.localAutoCommitMode);
            }
        }
        catch (SQLTimeoutException ste) {
            throw new PGXAException("Error committing prepared transaction", ste, -7);
        }
        catch (SQLException ex) {
            if ("42704".equals(ex.getSQLState())) {
                throw new PGXAException("Error commiting prepared transaction", ex, -4);
            }
            throw new PGXAException("Error committing prepared transaction", ex, -3);
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return xares == this;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new PGXAException("Heuristic commit/rollback not supported", -4);
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        return false;
    }

    int getState() {
        return this.state;
    }
}

