/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.ArrayUtilities;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.Type;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum BindingFlags {
    Default(0),
    IgnoreCase(1),
    DeclaredOnly(2),
    Instance(4),
    Static(8),
    Public(16),
    NonPublic(32),
    FlattenHierarchy(64),
    InvokeMethod(256),
    CreateInstance(512),
    GetField(1024),
    SetField(2048),
    ExactBinding(65536),
    SuppressChangeType(131072),
    OptionalParamBinding(262144),
    IgnoreReturn(0x1000000);

    public static final Set<BindingFlags> PublicStatic;
    public static final Set<BindingFlags> PublicInstance;
    public static final Set<BindingFlags> PublicAll;
    public static final Set<BindingFlags> NonPublicStatic;
    public static final Set<BindingFlags> NonPublicInstance;
    public static final Set<BindingFlags> NonPublicAll;
    public static final Set<BindingFlags> All;
    public static final Set<BindingFlags> AllStatic;
    public static final Set<BindingFlags> AllInstance;
    public static final Set<BindingFlags> PublicStaticDeclared;
    public static final Set<BindingFlags> PublicInstanceDeclared;
    public static final Set<BindingFlags> PublicAllDeclared;
    public static final Set<BindingFlags> NonPublicStaticDeclared;
    public static final Set<BindingFlags> NonPublicInstanceDeclared;
    public static final Set<BindingFlags> NonPublicAllDeclared;
    public static final Set<BindingFlags> AllDeclared;
    public static final Set<BindingFlags> AllStaticDeclared;
    public static final Set<BindingFlags> AllInstanceDeclared;
    public static final Set<BindingFlags> PublicStaticExact;
    public static final Set<BindingFlags> PublicInstanceExact;
    public static final Set<BindingFlags> PublicAllExact;
    public static final Set<BindingFlags> NonPublicStaticExact;
    public static final Set<BindingFlags> NonPublicInstanceExact;
    public static final Set<BindingFlags> NonPublicAllExact;
    public static final Set<BindingFlags> AllExact;
    public static final Set<BindingFlags> AllStaticExact;
    public static final Set<BindingFlags> AllInstanceExact;
    private static final Set<BindingFlags> PublicOnly;
    private static final Set<BindingFlags> NonPublicOnly;
    private static final Set<BindingFlags> PublicDeclared;
    private static final Set<BindingFlags> NonPublicDeclared;
    private static final Set<BindingFlags>[] SingleEntrySets;
    private final int _mask;

    public int getMask() {
        return this._mask;
    }

    private BindingFlags(int mask) {
        this._mask = mask;
    }

    public static Set<BindingFlags> set(BindingFlags ... flags) {
        if (ArrayUtilities.isNullOrEmpty((Object[])flags)) {
            return Collections.emptySet();
        }
        BindingFlags firstFlag = flags[0];
        switch (flags.length) {
            case 1: {
                if (firstFlag == null) {
                    return Collections.emptySet();
                }
                return SingleEntrySets[firstFlag.ordinal()];
            }
            case 2: {
                if (firstFlag == null) {
                    BindingFlags secondFlag = flags[1];
                    if (secondFlag == null) {
                        return Collections.emptySet();
                    }
                    return SingleEntrySets[secondFlag.ordinal()];
                }
                if (firstFlag == Public) {
                    if (flags[1] == Instance) {
                        return PublicInstance;
                    }
                    if (flags[1] != Static) break;
                    return PublicStatic;
                }
                if (firstFlag == NonPublic) {
                    if (flags[1] == Instance) {
                        return NonPublicInstance;
                    }
                    if (flags[1] != Static) break;
                    return NonPublicStatic;
                }
                if (firstFlag == Static) {
                    if (flags[1] == Public) {
                        return PublicStatic;
                    }
                    if (flags[1] != NonPublic) break;
                    return NonPublicStatic;
                }
                if (firstFlag != Instance) break;
                if (flags[1] == Public) {
                    return PublicInstance;
                }
                if (flags[1] != NonPublic) break;
                return NonPublicInstance;
            }
        }
        BindingFlags singleValue = firstFlag;
        EnumSet<BindingFlags> newSet = null;
        int n = flags.length;
        for (int i = 1; i < n; ++i) {
            BindingFlags flag = flags[i];
            if (flag == null || flag == singleValue) continue;
            if (newSet != null) {
                newSet.add(flag);
                continue;
            }
            if (singleValue == null) {
                singleValue = flag;
                continue;
            }
            newSet = EnumSet.of(singleValue);
            newSet.add(flag);
        }
        if (newSet != null) {
            return Collections.unmodifiableSet(newSet);
        }
        if (singleValue != null) {
            return SingleEntrySets[singleValue.ordinal()];
        }
        return Collections.emptySet();
    }

    static Set<BindingFlags> fromMask(int mask) {
        Enum singleValue = null;
        EnumSet<Enum> newSet = null;
        for (BindingFlags value : BindingFlags.values()) {
            if ((value._mask & mask) == 0) continue;
            if (newSet != null) {
                newSet.add(value);
                continue;
            }
            if (singleValue == null) {
                singleValue = value;
                continue;
            }
            newSet = EnumSet.of(singleValue);
            newSet.add(value);
        }
        if (newSet != null) {
            return Collections.unmodifiableSet(newSet);
        }
        if (singleValue != null) {
            return SingleEntrySets[singleValue.ordinal()];
        }
        return Collections.emptySet();
    }

    static Set<BindingFlags> fromMember(MemberInfo member) {
        if (member instanceof Type) {
            return BindingFlags.fromTypeModifiers(member.getModifiers());
        }
        return BindingFlags.fromMethodModifiers(member.getModifiers());
    }

    private static Set<BindingFlags> fromMethodModifiers(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            if (Modifier.isStatic(modifiers)) {
                return PublicStatic;
            }
            return PublicInstance;
        }
        if (Modifier.isStatic(modifiers)) {
            return NonPublicStatic;
        }
        return NonPublicInstance;
    }

    private static Set<BindingFlags> fromTypeModifiers(int modifiers) {
        if (Modifier.isStatic(modifiers)) {
            if (Modifier.isPublic(modifiers)) {
                return PublicStatic;
            }
            return NonPublicStatic;
        }
        if (Modifier.isPublic(modifiers)) {
            return PublicOnly;
        }
        return NonPublicOnly;
    }

    static {
        PublicStatic = Collections.unmodifiableSet(EnumSet.of(Public, Static));
        PublicInstance = Collections.unmodifiableSet(EnumSet.of(Public, Instance));
        PublicAll = Collections.unmodifiableSet(EnumSet.of(Public, Instance, Static));
        NonPublicStatic = Collections.unmodifiableSet(EnumSet.of(NonPublic, Static));
        NonPublicInstance = Collections.unmodifiableSet(EnumSet.of(NonPublic, Instance));
        NonPublicAll = Collections.unmodifiableSet(EnumSet.of(NonPublic, Instance, Static));
        All = Collections.unmodifiableSet(EnumSet.of(Public, NonPublic, Instance, Static));
        AllStatic = Collections.unmodifiableSet(EnumSet.of(Public, NonPublic, Static));
        AllInstance = Collections.unmodifiableSet(EnumSet.of(Public, NonPublic, Instance));
        PublicStaticDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, Public, Static));
        PublicInstanceDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, Public, Instance));
        PublicAllDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, Public, Instance, Static));
        NonPublicStaticDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, NonPublic, Static));
        NonPublicInstanceDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, NonPublic, Instance));
        NonPublicAllDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, NonPublic, Instance, Static));
        AllDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, Public, NonPublic, Instance, Static));
        AllStaticDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, Public, NonPublic, Static));
        AllInstanceDeclared = Collections.unmodifiableSet(EnumSet.of(DeclaredOnly, Public, NonPublic, Instance));
        PublicStaticExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, Public, Static));
        PublicInstanceExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, Public, Instance));
        PublicAllExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, Public, Instance, Static));
        NonPublicStaticExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, NonPublic, Static));
        NonPublicInstanceExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, NonPublic, Instance));
        NonPublicAllExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, NonPublic, Instance, Static));
        AllExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, Public, NonPublic, Instance, Static));
        AllStaticExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, Public, NonPublic, Static));
        AllInstanceExact = Collections.unmodifiableSet(EnumSet.of(ExactBinding, Public, NonPublic, Instance));
        PublicOnly = Collections.unmodifiableSet(EnumSet.of(Public));
        NonPublicOnly = Collections.unmodifiableSet(EnumSet.of(NonPublic));
        PublicDeclared = Collections.unmodifiableSet(EnumSet.of(Public, DeclaredOnly));
        NonPublicDeclared = Collections.unmodifiableSet(EnumSet.of(NonPublic, DeclaredOnly));
        BindingFlags[] values = BindingFlags.values();
        Set[] singleEntrySets = (Set[])Array.newInstance(Set.class, values.length);
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            singleEntrySets[i] = Collections.singleton(values[i]);
        }
        SingleEntrySets = singleEntrySets;
    }
}

