/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.EntityType;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;

public class ParameterDeclaration
extends EntityDeclaration {
    public static final Role<Annotation> ANNOTATION_ROLE = EntityDeclaration.ANNOTATION_ROLE;

    public ParameterDeclaration() {
    }

    public ParameterDeclaration(String name, AstType type) {
        this.setName(name);
        this.setType(type);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType value) {
        this.setChildByRole(Roles.TYPE, value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.PARAMETER;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitParameterDeclaration(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ParameterDeclaration) {
            ParameterDeclaration otherDeclaration = (ParameterDeclaration)other;
            return !otherDeclaration.isNull() && this.matchAnnotationsAndModifiers(otherDeclaration, match) && ParameterDeclaration.matchString(this.getName(), otherDeclaration.getName()) && this.getType().matches(otherDeclaration.getType(), match);
        }
        return false;
    }

    public static ParameterDeclaration forPattern(Pattern pattern) {
        return new PatternPlaceholder((Pattern)VerifyArgument.notNull((Object)pattern, (String)"pattern"));
    }

    private static final class PatternPlaceholder
    extends ParameterDeclaration {
        final Pattern child;

        PatternPlaceholder(Pattern child) {
            this.child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }
    }
}

