/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntCharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.IntCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntCharMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.IntCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyIntIterate;

/**
 * ImmutableIntCharEmptyMap is an optimization for {@link ImmutableIntCharMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableIntCharEmptyMap implements ImmutableIntCharMap, Serializable
{
    static final ImmutableIntCharMap INSTANCE = new ImmutableIntCharEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\0';

    private Object readResolve()
    {
        return INSTANCE;
    }

    public char get(int key)
    {
        return EMPTY_VALUE;
    }

    public char getIfAbsent(int key, char ifAbsent)
    {
        return ifAbsent;
    }

    public char getOrThrow(int key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key)
    {
        return false;
    }

    public boolean containsValue(char value)
    {
        return false;
    }

    public void forEachValue(CharProcedure procedure)
    {
    }

    public void forEachKey(IntProcedure procedure)
    {
    }

    public void forEachKeyValue(IntCharProcedure procedure)
    {
    }

    public LazyIntIterable keysView()
    {
        return LazyIntIterate.empty();
    }

    public RichIterable<IntCharPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableIntCharMap select(IntCharPredicate predicate)
    {
        return this;
    }

    public ImmutableIntCharMap reject(IntCharPredicate predicate)
    {
        return this;
    }

    public ImmutableIntCharMap toImmutable()
    {
        return this;
    }

    public CharIterator charIterator()
    {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    public void forEach(CharProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
    }

    public int count(CharPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public char min()
    {
        throw new NoSuchElementException();
    }

    public char max()
    {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public char minIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public char[] toSortedArray()
    {
        return new char[0];
    }

    public MutableCharList toSortedList()
    {
        return new CharArrayList();
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public ImmutableCharBag select(CharPredicate predicate)
    {
        return CharBags.immutable.empty();
    }

    public ImmutableCharBag reject(CharPredicate predicate)
    {
        return CharBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Bags.immutable.empty();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public char[] toArray()
    {
        return new char[0];
    }

    public boolean contains(char value)
    {
        return false;
    }

    public boolean containsAll(char... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(CharIterable source)
    {
        return source.isEmpty();
    }

    public MutableCharList toList()
    {
        return new CharArrayList();
    }

    public MutableCharSet toSet()
    {
        return new CharHashSet();
    }

    public MutableCharBag toBag()
    {
        return new CharHashBag();
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableIntCharMap newWithKeyValue(int key, char value)
    {
        return new ImmutableIntCharSingletonMap(key, value);
    }

    public ImmutableIntCharMap newWithoutKey(int key)
    {
        return this;
    }

    public ImmutableIntCharMap newWithoutAllKeys(IntIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableIntSet keySet()
    {
        return UnmodifiableIntSet.of(new IntHashSet());
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(new CharArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof IntCharMap))
        {
            return false;
        }
        IntCharMap map = (IntCharMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
