/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatDoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.FloatDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableFloatDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.FloatDoublePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedFloatDoubleProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.map.mutable.primitive.FloatDoubleHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

/**
 * ImmutableFloatDoubleHashMap is the non-modifiable equivalent of {@link FloatDoubleHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableFloatDoubleHashMap implements ImmutableFloatDoubleMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatDoubleMap delegate;

    ImmutableFloatDoubleHashMap(FloatDoubleMap delegate)
    {
        this.delegate = new FloatDoubleHashMap(delegate);
    }

    public double get(float key)
    {
        return this.delegate.get(key);
    }

    public double getIfAbsent(float key, double ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(float key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(double value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatDoubleProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<FloatDoublePair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableFloatDoubleMap select(FloatDoublePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatDoubleMap reject(FloatDoublePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableFloatDoubleMap toImmutable()
    {
        return this;
    }

    public DoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(this.delegate.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(DoubleProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableDoubleBag select(DoublePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public double max()
    {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double min()
    {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public double[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public double[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(double value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableFloatDoubleMap newWithKeyValue(float key, double value)
    {
        MutableFloatDoubleMap map = new FloatDoubleHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatDoubleMap newWithoutKey(float key)
    {
        MutableFloatDoubleMap map = new FloatDoubleHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatDoubleMap newWithoutAllKeys(FloatIterable keys)
    {
        MutableFloatDoubleMap map = new FloatDoubleHashMap(this.size());
        map.putAll(this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(this.delegate.keySet());
    }

    public MutableDoubleCollection values()
    {
        return UnmodifiableDoubleCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableFloatDoubleMapSerializationProxy(this);
    }

    protected static class ImmutableFloatDoubleMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private FloatDoubleMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableFloatDoubleMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableFloatDoubleMapSerializationProxy(FloatDoubleMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedFloatDoubleProcedure()
                {
                    @Override
                    public void safeValue(float key, double value) throws IOException
                    {
                        out.writeFloat(key);
                        out.writeDouble(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableFloatDoubleMap deserializedMap = new FloatDoubleHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readFloat(), in.readDouble());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
