/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.lazy.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.LongToByteFunction;
import org.eclipse.collections.api.block.function.primitive.LongToCharFunction;
import org.eclipse.collections.api.block.function.primitive.LongToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.LongToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.LongToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.block.factory.primitive.LongPredicates;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.utility.internal.primitive.LongIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyLongIterate;

import java.util.NoSuchElementException;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 *
 * @since 5.0
 */
public abstract class AbstractLazyLongIterable implements LazyLongIterable
{
    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    public int size()
    {
        return this.count(LongPredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return LongIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return LongIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        LongIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(long value)
    {
        return this.anySatisfy(LongPredicates.equal(value));
    }

    public boolean containsAll(long... source)
    {
        return this.containsAll(LongSets.immutable.of(source));
    }

    public boolean containsAll(LongIterable source)
    {
        return source.allSatisfy((long value) -> AbstractLazyLongIterable.this.contains(value));
    }

    public LazyLongIterable select(LongPredicate predicate)
    {
        return LazyLongIterate.select(this, predicate);
    }

    public LazyLongIterable reject(LongPredicate predicate)
    {
        return LazyLongIterate.select(this, LongPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(LongToObjectFunction<? extends V> function)
    {
        return LazyLongIterate.collect(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyBooleanIterable collectBoolean(LongToBooleanFunction function)
    {
        return new CollectLongToBooleanIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyByteIterable collectByte(LongToByteFunction function)
    {
        return new CollectLongToByteIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyCharIterable collectChar(LongToCharFunction function)
    {
        return new CollectLongToCharIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyShortIterable collectShort(LongToShortFunction function)
    {
        return new CollectLongToShortIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyIntIterable collectInt(LongToIntFunction function)
    {
        return new CollectLongToIntIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyFloatIterable collectFloat(LongToFloatFunction function)
    {
        return new CollectLongToFloatIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyLongIterable collectLong(LongToLongFunction function)
    {
        return new CollectLongToLongIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyDoubleIterable collectDouble(LongToDoubleFunction function)
    {
        return new CollectLongToDoubleIterable(this, function);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return LongIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(LongPredicate predicate)
    {
        return LongIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return LongIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return LongIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return LongIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return LongIterableIterate.injectInto(this, injectedValue, function);
    }

    public long[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableLongList toList()
    {
        final MutableLongList list = new LongArrayList();
        this.forEach(list::add);
        return list;
    }

    public MutableLongSet toSet()
    {
        final MutableLongSet set = new LongHashSet();
        this.forEach(set::add);
        return set;
    }

    public MutableLongBag toBag()
    {
        final MutableLongBag bag = new LongHashBag();
        this.forEach(bag::add);
        return bag;
    }

    public long sum()
    {
        LongSumProcedure procedure = new LongSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long max()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        LongMaxProcedure procedure = new LongMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long maxIfEmpty(long ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.max();
    }

    public long min()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        LongMinProcedure procedure = new LongMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long minIfEmpty(long ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.min();
    }

    public double average()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        return (double) this.sum() / (double) this.size();
    }

    public double median()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0)
        {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double) first + (double) second) / 2.0;
        }
        return (double) sortedArray[middleIndex];
    }

    public long[] toSortedArray()
    {
        return this.toSortedList().toArray();
    }

    public MutableLongList toSortedList()
    {
        return LongArrayList.newList(this).sortThis();
    }

    private static final class LongMaxProcedure implements LongProcedure
    {
        private boolean visitedOnce;
        private long max;

        public void value(long each)
        {
            if (this.visitedOnce)
            {
                if (this.max < each)
                {
                    this.max = each;
                }
            }
            else
            {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public long getValue()
        {
            return this.max;
        }
    }

    private static final class LongMinProcedure implements LongProcedure
    {
        private boolean visitedOnce;
        private long min;

        public void value(long each)
        {
            if (this.visitedOnce)
            {
                if (each < this.min)
                {
                    this.min = each;
                }
            }
            else
            {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public long getValue()
        {
            return this.min;
        }
    }

    private static final class LongSumProcedure implements LongProcedure
    {
        private long sum = 0;

        public void value(long each)
        {
            this.sum += each;
        }

        public long getValue()
        {
            return this.sum;
        }
    }


    public LazyLongIterable asLazy()
    {
        return this;
    }
}
