/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file abstractUnmodifiablePrimitiveCollection.stg.
 *
 * @since 3.1.
 */
@ThreadSafe
public abstract class AbstractUnmodifiableIntCollection
        implements MutableIntCollection, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableIntCollection collection;

    protected AbstractUnmodifiableIntCollection(MutableIntCollection collection)
    {
        if(collection == null)
        {
            throw new IllegalArgumentException("Cannot create a AbstractUnmodifiableIntCollection on a null collection");
        }

        this.collection = collection;
    }

    protected MutableIntCollection getIntCollection()
    {
        return this.collection;
    }

    public int size()
    {
        return this.collection.size();
    }

    public boolean isEmpty()
    {
        return this.collection.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.collection.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(int value)
    {
        return this.collection.contains(value);
    }

    public boolean containsAll(int... source)
    {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(IntIterable source)
    {
        return this.collection.containsAll(source);
    }

    public boolean add(int newItem)
    {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(int... source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(IntIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(int value)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(IntIterable source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(int... source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(IntIterable source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(int... source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableIntIterator intIterator()
    {
        return new UnmodifiableIntIterator(this.collection.intIterator());
    }

    public void forEach(IntProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(IntProcedure procedure)
    {
        this.collection.forEach(procedure);
    }

    public int count(IntPredicate predicate)
    {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableIntCollection select(IntPredicate predicate)
    {
        return this.collection.select(predicate);
    }

    public MutableIntCollection reject(IntPredicate predicate)
    {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.collection.collect(function);
    }

    public MutableIntCollection with(int element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection without(int element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection withAll(IntIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection withoutAll(IntIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection asUnmodifiable()
    {
        return this;
    }

    public MutableIntCollection asSynchronized()
    {
        return new SynchronizedIntCollection(this);
    }

    public ImmutableIntCollection toImmutable()
    {
        return this.collection.toImmutable();
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.collection.sum();
    }

    public int max()
    {
        return this.collection.max();
    }

    public int min()
    {
        return this.collection.min();
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.collection.minIfEmpty(defaultValue);
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.collection.average();
    }

    public double median()
    {
        return this.collection.median();
    }

    public MutableIntList toSortedList()
    {
        return this.collection.toSortedList();
    }

    public int[] toSortedArray()
    {
        return this.collection.toSortedArray();
    }

    public int[] toArray()
    {
        return this.collection.toArray();
    }

    @Override
    public String toString()
    {
        return this.collection.toString();
    }

    public String makeString()
    {
        return this.collection.makeString();
    }

    public String makeString(String separator)
    {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableIntList toList()
    {
        return this.collection.toList();
    }

    public MutableIntSet toSet()
    {
        return this.collection.toSet();
    }

    public MutableIntBag toBag()
    {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.collection.injectInto(injectedValue, function);
    }
}
