/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.region.ui;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Composite;
import org.simantics.district.region.ui.DiagramRegionsTableUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramRegionsTableView {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagramRegionsTableView.class);
    DiagramRegionsTableUI ui;
    public static final String POPUP_ID = "org.simantics.district.region.ui.popup";

    @Inject
    public void init(MPart part, MApplication app) {
        MHandledToolItem createHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        createHandledToolItem.setCommand(app.getCommand("org.simantics.district.region.ui.command.createRegionFromSelection"));
        createHandledToolItem.setLabel("Create Region From Selection");
        createHandledToolItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/table_add.png");
        MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
        toolBar.setToBeRendered(true);
        toolBar.getChildren().add(createHandledToolItem);
        part.setToolbar(toolBar);
        MPopupMenu createPopupMenu = MMenuFactory.INSTANCE.createPopupMenu();
        createPopupMenu.setElementId(POPUP_ID);
        createHandledToolItem.setContributorURI("org.simantics.district.region.ui.contextMenu");
        List menuContributions = app.getMenuContributions();
        for (MMenuContribution menuContribution : menuContributions) {
            if (!"org.simantics.district.region.ui.contextMenu".equals(menuContribution.getParentId())) continue;
            createPopupMenu.getChildren().addAll(menuContribution.getChildren());
        }
        part.getMenus().add(createPopupMenu);
    }

    @PostConstruct
    public void postConstruct(ESelectionService selectionService, Composite parent, EMenuService menuService) {
        this.ui = new DiagramRegionsTableUI(selectionService, parent, 0);
        if (!menuService.registerContextMenu((Object)this.ui.getTree(), POPUP_ID)) {
            LOGGER.warn("Could not register context menu {}", (Object)POPUP_ID);
        }
    }

    @PreDestroy
    public void dispose() {
        this.ui.dispose();
        this.ui = null;
    }

    @Focus
    public void onFocus() {
        this.ui.setFocus();
    }
}

